/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.persistence.CannotConnectException;
import org.jgroups.persistence.CannotCreateSchemaException;
import org.jgroups.persistence.CannotPersistException;
import org.jgroups.persistence.CannotRemoveException;
import org.jgroups.persistence.CannotRetrieveException;
import org.jgroups.persistence.PersistenceManager;

public class DBPersistenceManager
implements PersistenceManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Properties props = null;
    private String driverName = null;
    private String userName = null;
    private String userPass = null;
    private String connStr = null;
    private String createTable = null;
    private final boolean oracleDB = false;
    private Vector list = null;
    private static final String tabName = "replhashmap";
    private static final String insertStat = "insert into replhashmap(key, keyBin, valBin) values  (?, ?, ?)";
    private static final String updateStat = "update replhashmap set keyBin = ?, valBin = ? where key like ?";
    private static final String removeStat = " delete from replhashmap where key like ?";
    private static final String createTableGen = " create table replhashmap(key varchar, keyBin varbinary, valBin varbinary)";
    private static final String createTableOra = " create table replhashmap ( key varchar2(100), keyBin blob, valBin blob)";

    public DBPersistenceManager(String filename) throws Exception {
        String home_dir = null;
        try {
            home_dir = System.getProperty("user.home");
        }
        catch (SecurityException ex1) {
            // empty catch block
        }
        try {
            home_dir = home_dir + '/' + filename;
            this.init(new FileInputStream(home_dir));
            return;
        }
        catch (Exception ex) {
            block9: {
                try {
                    InputStream in = DBPersistenceManager.class.getResourceAsStream('/' + filename);
                    if (in != null) {
                        this.init(in);
                        return;
                    }
                }
                catch (Exception x) {
                    if (!this.log.isErrorEnabled()) break block9;
                    this.log.error((Object)("failed reading database properties from " + filename + ", exception=" + x));
                }
            }
            try {
                home_dir = System.getProperty("persist.properties");
                this.init(new FileInputStream(home_dir));
                return;
            }
            catch (Exception exception) {
                throw new Exception("DBPersistenceManager.DBPersistenceManager(): failed reading database properties from " + filename);
            }
        }
    }

    public DBPersistenceManager(InputStream input) throws Exception {
        this.init(input);
    }

    protected void init(InputStream in) throws Exception {
        this.list = new Vector();
        this.readProps(in);
        this.loadDriver();
        Connection conn = this.getConnection();
        this.closeConnection(conn);
        this.createDBTables();
        this.retrieveAll();
        this.log.error((Object)" Done constructing DB Persist Manager");
    }

    /*
     * Loose catch block
     */
    public void save(Serializable key, Serializable val) throws CannotPersistException {
        block12: {
            if (!this.entryExists(key)) {
                this.log.error((Object)(" entry doesnt exist for " + key.toString()));
                try {
                    this.addNewEntry(key, val);
                    this.list.add(key.toString());
                    return;
                }
                catch (Throwable t1) {
                    t1.printStackTrace();
                    throw new CannotPersistException(t1, " error adding a completely new entry in to DB ");
                }
            }
            Connection conn = null;
            Statement prepStat = null;
            conn = this.getConnection();
            String keyStr = null;
            keyStr = key.toString();
            byte[] keyBytes = this.getBytes(key);
            byte[] valBytes = this.getBytes(val);
            this.log.error((Object)(" value is " + val));
            prepStat = conn.prepareStatement(updateStat);
            prepStat.setString(3, keyStr);
            prepStat.setBytes(1, keyBytes);
            prepStat.setBytes(2, valBytes);
            prepStat.executeQuery();
            Object var9_10 = null;
            try {
                if (prepStat != null) {
                    prepStat.close();
                }
                this.closeConnection(conn);
            }
            catch (Throwable t) {
                conn = null;
                prepStat = null;
            }
            break block12;
            {
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new CannotPersistException(t, "error updating an existing entry in to the database ");
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (prepStat != null) {
                        prepStat.close();
                    }
                    this.closeConnection(conn);
                }
                catch (Throwable t) {
                    conn = null;
                    prepStat = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Serializable remove(Serializable key) throws CannotRemoveException {
        Serializable val;
        block19: {
            ResultSet set;
            Statement prepStat;
            Statement stat;
            Connection conn;
            block18: {
                conn = null;
                stat = null;
                prepStat = null;
                set = null;
                val = null;
                conn = this.getConnection();
                stat = conn.createStatement();
                String exQuery = " select * from replhashmap where key like '" + key.toString() + '\'';
                set = stat.executeQuery(exQuery);
                set.next();
                val = this.getSerializable(set.getBinaryStream(3));
                Object var9_10 = null;
                try {
                    if (prepStat != null) {
                        prepStat.close();
                    }
                    this.closeConnection(conn);
                }
                catch (Throwable t) {
                    conn = null;
                    prepStat = null;
                }
                break block18;
                {
                    catch (Throwable t3) {
                        t3.printStackTrace();
                        throw new CannotRemoveException(t3, " Error retrieving value for given key");
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    try {
                        if (prepStat != null) {
                            prepStat.close();
                        }
                        this.closeConnection(conn);
                    }
                    catch (Throwable t) {
                        conn = null;
                        prepStat = null;
                    }
                    throw throwable;
                }
            }
            conn = this.getConnection();
            prepStat = conn.prepareStatement(removeStat);
            prepStat.setString(1, key.toString());
            prepStat.executeQuery();
            this.list.remove(key.toString());
            Object var12_15 = null;
            try {
                set.close();
                stat.close();
                if (prepStat != null) {
                    prepStat.close();
                }
                this.closeConnection(conn);
            }
            catch (Throwable t) {
                conn = null;
                stat = null;
            }
            break block19;
            {
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new CannotRemoveException(t, "Could not remove existing entry due to error in jdbc transaction");
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    set.close();
                    stat.close();
                    if (prepStat != null) {
                        prepStat.close();
                    }
                    this.closeConnection(conn);
                }
                catch (Throwable t) {
                    conn = null;
                    stat = null;
                }
                throw throwable;
            }
        }
        return val;
    }

    public synchronized void saveAll(Map map) throws CannotPersistException {
        Iterator iter = null;
        try {
            Set keySet = map.keySet();
            iter = keySet.iterator();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new CannotPersistException(t, "Error with the map entered to saveAll");
        }
        while (iter.hasNext()) {
            try {
                Serializable key = (Serializable)iter.next();
                Serializable val = (Serializable)map.get(key);
                this.save(key, val);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    public synchronized Map retrieveAll() throws CannotRetrieveException {
        Connection conn = null;
        Statement stat = null;
        ResultSet set = null;
        Map map = null;
        try {
            conn = this.getConnection();
            stat = conn.createStatement();
            set = stat.executeQuery(" select * from replhashmap");
            map = this.retrieveAll(set);
        }
        catch (Throwable t) {
            throw new CannotRetrieveException(t, "Error happened while querying the database for bulk retrieve, try starting DB manually");
        }
        try {
            stat.close();
            this.closeConnection(conn);
        }
        catch (Throwable t1) {
            // empty catch block
        }
        return map;
    }

    private Map retrieveAll(ResultSet result) throws Exception {
        HashMap<Serializable, Serializable> map = new HashMap<Serializable, Serializable>();
        while (result.next()) {
            InputStream inputStrKey = result.getBinaryStream(2);
            InputStream inputStrVal = result.getBinaryStream(3);
            Serializable key = this.getSerializable(inputStrKey);
            Serializable val = this.getSerializable(inputStrVal);
            map.put(key, val);
            this.list.add(key.toString());
        }
        return map;
    }

    public void clear() throws CannotRemoveException {
        Connection conn = null;
        Statement stat = null;
        try {
            conn = this.getConnection();
            stat = conn.createStatement();
            stat.executeQuery("delete from replhashmap");
        }
        catch (Throwable t) {
            throw new CannotRemoveException(t, " delete all query failed with existing database");
        }
        try {
            stat.close();
            this.closeConnection(conn);
        }
        catch (Throwable t) {
            conn = null;
            stat = null;
        }
    }

    public void shutDown() {
    }

    private void addNewEntry(Serializable key, Serializable val) throws CannotPersistException, CannotConnectException {
        Connection conn = this.getConnection();
        try {
            PreparedStatement prepStat = conn.prepareStatement(insertStat);
            prepStat.setString(1, key.toString());
            byte[] keyBytes = this.getBytes(key);
            byte[] valBytes = this.getBytes(val);
            prepStat.setBytes(2, keyBytes);
            prepStat.setBytes(3, valBytes);
            prepStat.executeQuery();
            conn.commit();
            this.log.error((Object)" executing insert insert into replhashmap(key, keyBin, valBin) values  (?, ?, ?)");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new CannotPersistException(t, "error adding new entry using creating Db connection and schema");
        }
    }

    private InputStream getBinaryInputStream(Serializable ser) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream keyoos = new ObjectOutputStream(stream);
        keyoos.writeObject(ser);
        ByteArrayInputStream pipe = new ByteArrayInputStream(stream.toByteArray());
        return pipe;
    }

    private Serializable getSerializable(InputStream stream) throws Exception {
        ObjectInputStream ooStr = new ObjectInputStream(stream);
        Serializable tmp = (Serializable)ooStr.readObject();
        return tmp;
    }

    private void addNewEntryGen(Serializable key, Serializable val) throws CannotPersistException, CannotConnectException {
        Connection conn = this.getConnection();
        try {
            PreparedStatement prepStat = conn.prepareStatement(insertStat);
            prepStat.setString(1, key.toString());
            prepStat.setBytes(2, this.getBytes(key));
            prepStat.setBytes(3, this.getBytes(val));
            prepStat.executeUpdate();
        }
        catch (Throwable t) {
            throw new CannotPersistException(t, "error adding new entry using creating Db connection and schema");
        }
    }

    private void addNewEntryOra(Serializable key, Serializable val) throws CannotPersistException, CannotConnectException {
        Connection conn = this.getConnection();
        try {
            PreparedStatement prepStat = conn.prepareStatement(insertStat);
            prepStat.setString(1, key.toString());
            InputStream keyBin = this.getBinaryInputStream(key);
            InputStream keyVal = this.getBinaryInputStream(val);
            byte[] keyBytes = this.getBytes(key);
            byte[] valBytes = this.getBytes(val);
            prepStat.setBytes(2, keyBytes);
            prepStat.setBytes(3, valBytes);
            prepStat.executeBatch();
        }
        catch (Throwable t) {
            throw new CannotPersistException(t, "error adding new entry using creating Db connection and schema");
        }
    }

    private boolean entryExists(Serializable key) {
        return this.list.contains(key.toString());
    }

    private byte[] getBytes(Serializable ser) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream keyoos = new ObjectOutputStream(stream);
        keyoos.writeObject(ser);
        byte[] keyBytes = stream.toByteArray();
        return keyBytes;
    }

    private void readProps(String filePath) throws Exception {
        FileInputStream _stream = new FileInputStream(filePath);
        this.props = new Properties();
        this.props.load(_stream);
        this.driverName = this.props.getProperty("jdbc.Driver");
        this.connStr = this.props.getProperty("jdbc.Conn").trim();
        this.userName = this.props.getProperty("jdbc.User").trim();
        this.userPass = this.props.getProperty("jdbc.Pass").trim();
        this.createTable = this.props.getProperty("jdbc.table").trim();
    }

    private void readProps(InputStream input) throws Exception {
        this.props = new Properties();
        this.props.load(input);
        this.driverName = this.props.getProperty("jdbc.Driver");
        this.connStr = this.props.getProperty("jdbc.Conn");
        this.userName = this.props.getProperty("jdbc.User");
        this.userPass = this.props.getProperty("jdbc.Pass");
        this.createTable = this.props.getProperty("jdbc.table");
    }

    private void loadDriver() throws Exception {
        Class.forName(this.driverName);
    }

    private Connection getConnection() throws CannotConnectException {
        try {
            this.connStr = this.connStr.trim();
            Connection conn = DriverManager.getConnection(this.connStr, this.userName, this.userPass);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("userName=" + this.userName + ", userPass=" + this.userPass + ", connStr=" + this.connStr));
            }
            return conn;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new CannotConnectException(t, "Error in creating connection using provided properties ");
        }
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
        catch (Throwable t) {
            conn = null;
        }
    }

    private void createDBTables() throws CannotCreateSchemaException, CannotConnectException {
        Connection conn = this.getConnection();
        Statement stat = null;
        try {
            stat = conn.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotConnectException(e, "there was an error in creating statements for persisting data using created connection");
        }
        try {
            ResultSet set = stat.executeQuery("select * from replhashmap");
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.addSchemaToDB(conn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addSchemaToDB(Connection conn) throws CannotCreateSchemaException {
        Statement stat = null;
        Object stat2 = null;
        try {
            try {
                stat = conn.createStatement();
                this.log.error((Object)(" executing query for oracle " + this.createTable));
                stat.executeQuery(this.createTable);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new CannotCreateSchemaException(t, "error was using schema with blobs");
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (stat != null) {
                    stat.close();
                }
                this.closeConnection(conn);
                throw throwable;
            }
            catch (Throwable t3) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable t3) {}
        if (stat != null) {
            stat.close();
        }
        this.closeConnection(conn);
        return;
    }
}

