/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.finder.impl;

import java.net.URI;
import java.util.ArrayList;
import org.apache.xpath.XPathAPI;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinderModule;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectorModule
extends AttributeFinderModule {
    public boolean isSelectorSupported() {
        return true;
    }

    private EvaluationResult createProcessingError(String msg) {
        ArrayList<String> code = new ArrayList<String>();
        code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
        return new EvaluationResult(new Status(code, msg));
    }

    public EvaluationResult findAttribute(String path, Node namespaceNode, URI type, EvaluationCtx context, String xpathVersion) {
        int i;
        if (!xpathVersion.equals("http://www.w3.org/TR/1999/Rec-xpath-19991116")) {
            return new EvaluationResult(BagAttribute.createEmptyBag(type));
        }
        Node root = context.getRequestRoot();
        Node nsNode = namespaceNode != null ? namespaceNode : root;
        String rootPath = "";
        if (path.charAt(0) != '/') {
            String rootName = root.getLocalName();
            String namespace = root.getNamespaceURI();
            if (namespace == null) {
                rootPath = "/" + rootName + "/";
            } else {
                NamedNodeMap nmap = namespaceNode.getAttributes();
                rootPath = null;
                for (i = 0; i < nmap.getLength(); ++i) {
                    Node n = nmap.item(i);
                    if (!n.getNodeValue().equals(namespace)) continue;
                    String name = SunxacmlUtil.getNodeName(n);
                    int pos = name.indexOf(58);
                    rootPath = pos == -1 ? "/" : "/" + name.substring(pos + 1);
                    rootPath = rootPath + ":" + rootName + "/";
                    break;
                }
                if (rootPath == null) {
                    return this.createProcessingError("Failed to map a namespace in an XPath expression");
                }
            }
        }
        NodeList matches = null;
        try {
            matches = XPathAPI.selectNodeList((Node)root, (String)(rootPath + path), (Node)nsNode);
        }
        catch (Exception e) {
            return this.createProcessingError("error in XPath: " + e.getMessage());
        }
        if (matches.getLength() == 0) {
            return new EvaluationResult(BagAttribute.createEmptyBag(type));
        }
        try {
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>();
            AttributeFactory attrFactory = AttributeFactory.getInstance();
            for (i = 0; i < matches.getLength(); ++i) {
                String text = null;
                Node node = matches.item(i);
                short nodeType = node.getNodeType();
                text = nodeType == 4 || nodeType == 8 || nodeType == 3 || nodeType == 2 ? node.getNodeValue() : node.getFirstChild().getNodeValue();
                list.add(attrFactory.createValue(type, text));
            }
            return new EvaluationResult(new BagAttribute(type, list));
        }
        catch (ParsingException pe) {
            return this.createProcessingError(pe.getMessage());
        }
        catch (UnknownIdentifierException uie) {
            return this.createProcessingError("unknown attribute type: " + type);
        }
    }
}

