/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.support.finder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.Target;
import org.jboss.security.xacml.sunxacml.TargetSection;
import org.jboss.security.xacml.sunxacml.VersionConstraints;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.jboss.security.xacml.sunxacml.support.finder.TopLevelPolicyException;

public class PolicyCollection {
    private HashMap policies;
    private VersionComparator versionComparator = new VersionComparator();
    private PolicyCombiningAlgorithm combiningAlg;
    private URI parentId;
    private static final Target target = new Target(new TargetSection(null, 0, 2), new TargetSection(null, 1, 2), new TargetSection(null, 2, 2), new TargetSection(null, 3, 2));

    public PolicyCollection() {
        this.policies = new HashMap();
        this.combiningAlg = null;
    }

    public PolicyCollection(PolicyCombiningAlgorithm combiningAlg, URI parentPolicyId) {
        this.policies = new HashMap();
        this.combiningAlg = combiningAlg;
        this.parentId = parentPolicyId;
    }

    public boolean addPolicy(AbstractPolicy policy) {
        return this.addPolicy(policy, policy.getId().toString());
    }

    public boolean addPolicy(AbstractPolicy policy, String identifier) {
        if (this.policies.containsKey(identifier)) {
            TreeSet set = (TreeSet)this.policies.get(identifier);
            return set.add(policy);
        }
        TreeSet<AbstractPolicy> set = new TreeSet<AbstractPolicy>(this.versionComparator);
        this.policies.put(identifier, set);
        return set.add(policy);
    }

    public AbstractPolicy getPolicy(EvaluationCtx context) throws TopLevelPolicyException {
        ArrayList<AbstractPolicy> list = new ArrayList<AbstractPolicy>();
        Iterator it = this.policies.values().iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = (AbstractPolicy)((TreeSet)it.next()).first();
            MatchResult match = policy.match(context);
            int result = match.getResult();
            if (result == 2) {
                throw new TopLevelPolicyException(match.getStatus());
            }
            if (result != 0) continue;
            if (this.combiningAlg == null && list.size() > 0) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                throw new TopLevelPolicyException(status);
            }
            list.add(policy);
        }
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (AbstractPolicy)list.get(0);
            }
        }
        return new PolicySet(this.parentId, this.combiningAlg, target, list);
    }

    public AbstractPolicy getPolicy(String identifier, int type, VersionConstraints constraints) {
        TreeSet set = (TreeSet)this.policies.get(identifier);
        if (set == null) {
            return null;
        }
        for (AbstractPolicy policy : set) {
            if (!constraints.meetsConstraint(policy.getVersion()) || !(type == 0 ? policy instanceof Policy : policy instanceof PolicySet)) continue;
            return policy;
        }
        return null;
    }

    class VersionComparator
    implements Comparator {
        VersionComparator() {
        }

        public int compare(Object o1, Object o2) {
            String v2;
            String v1 = ((AbstractPolicy)o2).getVersion();
            if (v1.equals(v2 = ((AbstractPolicy)o1).getVersion())) {
                return 0;
            }
            StringTokenizer tok1 = new StringTokenizer(v1, ".");
            StringTokenizer tok2 = new StringTokenizer(v2, ".");
            while (tok1.hasMoreTokens()) {
                int num2;
                if (!tok2.hasMoreTokens()) {
                    return 1;
                }
                int num1 = Integer.parseInt(tok1.nextToken());
                if (num1 > (num2 = Integer.parseInt(tok2.nextToken()))) {
                    return 1;
                }
                if (num1 >= num2) continue;
                return -1;
            }
            if (tok2.hasMoreTokens()) {
                return -1;
            }
            return 0;
        }
    }
}

