/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.util;

import java.awt.Rectangle;
import java.util.List;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.util.PDFTextStripperByArea;

public class ExtractTextByArea {
    private ExtractTextByArea() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            ExtractTextByArea.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: Document is encrypted with a password.");
                        System.exit(1);
                    }
                }
                PDFTextStripperByArea stripper = new PDFTextStripperByArea();
                stripper.setSortByPosition(true);
                Rectangle rect = new Rectangle(10, 280, 275, 60);
                stripper.addRegion("class1", rect);
                List allPages = document.getDocumentCatalog().getAllPages();
                PDPage firstPage = (PDPage)allPages.get(0);
                stripper.extractRegions(firstPage);
                System.out.println("Text in the area:" + rect);
                System.out.println(stripper.getTextForRegion("class1"));
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.util.ExtractTextByArea <input-pdf>");
    }
}

