/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.application.impl;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceService;

public class SocialGroupEventListenerImpl
extends GroupEventListener {
    private SpaceService spaceService;

    public void preSave(Group group, boolean isNew) throws Exception {
    }

    public void postSave(Group group, boolean isNew) throws Exception {
    }

    public void preDelete(Group group) throws Exception {
        SpaceService spaceSrv = this.getSpaceService();
        List<Space> allSpaces = spaceSrv.getAllSpaces();
        String groupId = group.getId();
        String groupIdOfSpace = null;
        for (Space space : allSpaces) {
            groupIdOfSpace = space.getGroupId();
            if (!groupId.equals(groupIdOfSpace)) continue;
            spaceSrv.deleteSpace(space);
        }
        UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkSpace = (UIWorkingWorkspace)uiPortalApp.getChild(UIWorkingWorkspace.class);
        uiWorkSpace.updatePortletsByName("SpacesToolbarPortlet");
        uiWorkSpace.updatePortletsByName("SocialUserToolBarGroupPortlet");
    }

    public void postDelete(Group group) throws Exception {
    }

    private SpaceService getSpaceService() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)container.getComponentInstance(SpaceService.class);
        }
        return this.spaceService;
    }
}

