/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;

public class SpaceAttachment {
    private String id;
    private String fileName;
    private String mimeType;
    private String workspace;
    private byte[] imageBytes;
    private long lastModified;
    private static final int KB_SIZE = 1024;
    private static final int MB_SIZE = 0x100000;

    public String getDataPath() throws Exception {
        Node attachmentData;
        try {
            attachmentData = (Node)this.getSession().getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return attachmentData.getPath();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String ws) {
        this.workspace = ws;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String s) {
        this.fileName = s;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String s) {
        this.mimeType = s;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getImageSize() {
        int length = this.imageBytes.length;
        if (length >= 0x100000) {
            double size = length / 0x100000;
            return size + " MB";
        }
        if (length >= 1024) {
            double size = length / 1024;
            return size + " KB";
        }
        return length + " Bytes";
    }

    public void setInputStream(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes = new byte[input.available()];
            input.read(this.imageBytes);
        } else {
            this.imageBytes = null;
        }
    }

    public InputStream getInputStream(Session session) throws Exception {
        Node attachment;
        if (this.imageBytes != null) {
            return new ByteArrayInputStream(this.imageBytes);
        }
        try {
            attachment = (Node)session.getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (PathNotFoundException ex) {
            return null;
        }
        Property property = attachment.getNode("jcr:content").getProperty("jcr:data");
        InputStream inputStream = property.getValue().getStream();
        return inputStream;
    }

    private Session getSession() throws Exception {
        RepositoryService repoService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        return repoService.getDefaultRepository().getSystemSession(this.workspace);
    }
}

