/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.cache;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.store.AttributeStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheAttributeStoreWrapper
implements AttributeStore {
    private static Logger log = Logger.getLogger(JBossCacheAttributeStoreWrapper.class.getName());
    private final AttributeStore attributeStore;
    protected final IdentityStoreCacheProvider cacheSupport;
    protected final String cacheScope;

    public JBossCacheAttributeStoreWrapper(AttributeStore attributeStore, IdentityStoreCacheProvider cacheSupport, String cacheScope) {
        this.cacheSupport = cacheSupport;
        this.attributeStore = attributeStore;
        this.cacheScope = cacheScope;
    }

    protected String getCacheNS(IdentityStoreInvocationContext ctx) {
        if (this.cacheScope != null && this.cacheScope.equals("realm")) {
            return this.cacheSupport.getNamespace(this.attributeStore.getId(), ctx.getRealmId());
        }
        if (this.cacheScope != null && this.cacheScope.equals("session")) {
            return this.cacheSupport.getNamespace(this.attributeStore.getId(), ctx.getRealmId(), ctx.getSessionId());
        }
        return this.cacheSupport.getNamespace(this.attributeStore.getId());
    }

    public String getId() {
        return this.attributeStore.getId();
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        return this.attributeStore.createIdentityStoreSession();
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        return this.attributeStore.getSupportedAttributeNames(invocationContext, identityType);
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return this.attributeStore.getAttributesMetaData(invocationContext, identityType);
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext invocationContext, IdentityObject identity) throws IdentityException {
        Map results = this.cacheSupport.getIdentityObjectAttributes(this.getCacheNS(invocationContext), identity);
        if (results != null) {
            return results;
        }
        results = this.attributeStore.getAttributes(invocationContext, identity);
        this.cacheSupport.putIdentityObjectAttributes(this.getCacheNS(invocationContext), identity, results);
        return results;
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        Map results = this.cacheSupport.getIdentityObjectAttributes(this.getCacheNS(invocationContext), identity);
        if (results != null && results.containsKey(name)) {
            return (IdentityObjectAttribute)results.get(name);
        }
        IdentityObjectAttribute result = this.attributeStore.getAttribute(invocationContext, identity, name);
        if (result != null) {
            this.cacheSupport.invalidateIdentityObjectAttriubtes(this.getCacheNS(invocationContext), identity);
            this.cacheSupport.putIdentityObjectAttributes(this.getCacheNS(invocationContext), identity, this.attributeStore.getAttributes(invocationContext, identity));
        }
        return result;
    }

    public void updateAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        this.attributeStore.updateAttributes(invocationCtx, identity, attributes);
        this.cacheSupport.invalidateIdentityObjectAttriubtes(this.getCacheNS(invocationCtx), identity);
        this.cacheSupport.putIdentityObjectAttributes(this.getCacheNS(invocationCtx), identity, this.attributeStore.getAttributes(invocationCtx, identity));
    }

    public void addAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        this.attributeStore.addAttributes(invocationCtx, identity, attributes);
        this.cacheSupport.invalidateIdentityObjectAttriubtes(this.getCacheNS(invocationCtx), identity);
        this.cacheSupport.putIdentityObjectAttributes(this.getCacheNS(invocationCtx), identity, this.attributeStore.getAttributes(invocationCtx, identity));
    }

    public void removeAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, String[] attributeNames) throws IdentityException {
        this.attributeStore.removeAttributes(invocationCtx, identity, attributeNames);
        this.cacheSupport.invalidateIdentityObjectAttriubtes(this.getCacheNS(invocationCtx), identity);
        this.cacheSupport.putIdentityObjectAttributes(this.getCacheNS(invocationCtx), identity, this.attributeStore.getAttributes(invocationCtx, identity));
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        return this.attributeStore.findIdentityObjectByUniqueAttribute(invocationCtx, identityObjectType, attribute);
    }

    protected Logger getLog() {
        return log;
    }

    public String toString() {
        return "JBossCacheAttributeStoreWrapper (AttributeStore=" + this.attributeStore.getId() + ")";
    }
}

