/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.observation;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExtendedEventType {
    private final Log log = ExoLogger.getLogger((String)"jcr.ExtendedEventType");
    public static final String NODE_ADDED = "Node is added";
    public static final String NODE_REMOVED = "Node is removed";
    public static final String PROPERTY_ADDED = "Property is added";
    public static final String PROPERTY_REMOVED = "Property is removed";
    public static final String PROPERTY_CHANGED = "Property is changed";
    public static final String SAVE = "Save";
    public static final String MOVE = "Move";
    public static final String COPY = "Copy";
    public static final String ADD_MIXIN = "Mixin is added";
    public static final String REMOVE_MIXIN = "Mixin is removed";
    public static final String CLONE = "Clone";
    public static final String UPDATE = "Item is updated";
    public static final String IMPORT = "Import";
    public static final String CHECKIN = "Checkin";
    public static final String CHECKOUT = "Checkout";
    public static final String RESTORE = "Restore";
    public static final String MERGE = "Merge";
    public static final String CANCEL_MERGE = "Cancel merge";
    public static final String DONE_MERGE = "Done merge";
    public static final String ADD_VERSION_LABEL = "Version label added";
    public static final String REMOVE_VERSION_LABEL = "Version label removed";
    public static final String REMOVE_VERSION = "Version removed";
    public static final String LOCK = "Lock";
    public static final String UNLOCK = "Unlock";
    public static final String READ = "Read";

    public static String nameFromValue(int event) {
        switch (event) {
            case 1: {
                return NODE_ADDED;
            }
            case 2: {
                return NODE_REMOVED;
            }
            case 4: {
                return PROPERTY_ADDED;
            }
            case 8: {
                return PROPERTY_REMOVED;
            }
            case 16: {
                return PROPERTY_CHANGED;
            }
            case 32: {
                return SAVE;
            }
            case 64: {
                return MOVE;
            }
            case 128: {
                return COPY;
            }
            case 256: {
                return ADD_MIXIN;
            }
            case 512: {
                return REMOVE_MIXIN;
            }
            case 1024: {
                return CLONE;
            }
            case 2048: {
                return UPDATE;
            }
            case 4096: {
                return IMPORT;
            }
            case 8192: {
                return CHECKIN;
            }
            case 16384: {
                return CHECKOUT;
            }
            case 32768: {
                return RESTORE;
            }
            case 65536: {
                return MERGE;
            }
            case 131072: {
                return CANCEL_MERGE;
            }
            case 262144: {
                return DONE_MERGE;
            }
            case 524288: {
                return ADD_VERSION_LABEL;
            }
            case 0x100000: {
                return REMOVE_VERSION_LABEL;
            }
            case 0x200000: {
                return REMOVE_VERSION;
            }
            case 0x400000: {
                return LOCK;
            }
            case 0x800000: {
                return UNLOCK;
            }
            case 0x1000000: {
                return READ;
            }
        }
        return "";
    }

    public static int valueFromName(String name) {
        if (name.equals(NODE_ADDED)) {
            return 1;
        }
        if (name.equals(NODE_REMOVED)) {
            return 2;
        }
        if (name.equals(PROPERTY_ADDED)) {
            return 4;
        }
        if (name.equals(PROPERTY_REMOVED)) {
            return 8;
        }
        if (name.equals(PROPERTY_CHANGED)) {
            return 16;
        }
        if (name.equals(SAVE)) {
            return 32;
        }
        if (name.equals(MOVE)) {
            return 64;
        }
        if (name.equals(COPY)) {
            return 128;
        }
        if (name.equals(ADD_MIXIN)) {
            return 256;
        }
        if (name.equals(REMOVE_MIXIN)) {
            return 512;
        }
        if (name.equals(CLONE)) {
            return 1024;
        }
        if (name.equals(UPDATE)) {
            return 2048;
        }
        if (name.equals(IMPORT)) {
            return 4096;
        }
        if (name.equals(CHECKIN)) {
            return 8192;
        }
        if (name.equals(CHECKOUT)) {
            return 16384;
        }
        if (name.equals(RESTORE)) {
            return 32768;
        }
        if (name.equals(MERGE)) {
            return 65536;
        }
        if (name.equals(CANCEL_MERGE)) {
            return 131072;
        }
        if (name.equals(DONE_MERGE)) {
            return 262144;
        }
        if (name.equals(ADD_VERSION_LABEL)) {
            return 524288;
        }
        if (name.equals(REMOVE_VERSION_LABEL)) {
            return 0x100000;
        }
        if (name.equals(REMOVE_VERSION)) {
            return 0x200000;
        }
        if (name.equals(LOCK)) {
            return 0x400000;
        }
        if (name.equals(UNLOCK)) {
            return 0x800000;
        }
        if (name.equals(READ)) {
            return 0x1000000;
        }
        return -1;
    }
}

