/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.exoplatform.swing.Application;
import org.exoplatform.swing.ViewPlugin;
import org.exoplatform.wsqa.httpclient.WebUnit;
import org.exoplatform.wsqa.httpclient.WebUnitExecuteContext;
import org.exoplatform.wsqa.httpclient.WebUnitListener;
import org.exoplatform.wsqa.swing.WebUnitDataViewPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientResultPanel
extends JPanel
implements ViewPlugin {
    public static final String WORKSPACE_NAME = "WSQAWorkspace";
    private static String[] TABLE_HEADERS = new String[]{"#", "Name", "Description", "Error"};
    private List<WebUnitExecuteContext> datas_ = new ArrayList<WebUnitExecuteContext>();
    private RunDataTableModel webunitTableModel_;
    private JTable jtable_;
    private JPopupMenu popupMenu = new WebunitExecuteContextPopupMenu();

    public HttpClientResultPanel() {
        this.setLayout(new BorderLayout());
        this.jtable_ = new JTable();
        this.jtable_.setDefaultRenderer(Object.class, new TableRowColorRenderer());
        this.webunitTableModel_ = new RunDataTableModel((Object[][])null, TABLE_HEADERS);
        this.jtable_.setModel(this.webunitTableModel_);
        this.jtable_.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3 || evt.isPopupTrigger()) {
                    JTable source = (JTable)evt.getSource();
                    source.getSelectedRow();
                    HttpClientResultPanel.this.popupMenu.show(source, evt.getX(), evt.getY());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.jtable_);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public String getName() {
        return WORKSPACE_NAME;
    }

    @Override
    public String getTitle() {
        return "WSQA Workspace";
    }

    public List<WebUnitExecuteContext> getRunDatas() {
        return this.datas_;
    }

    public int getSelectedRow() {
        return this.jtable_.getSelectedRow();
    }

    public WebUnitExecuteContext getSelectedRunData() {
        return this.datas_.get(this.jtable_.getSelectedRow());
    }

    public void addData(WebUnitExecuteContext context) throws Exception {
        this.datas_.add(context);
        Object[] rowData = new String[]{Integer.toString(this.webunitTableModel_.getRowCount()), context.getRequest().getHeaders().getUri().getPathInfo(), ".....", Boolean.toString(context.hasError())};
        this.webunitTableModel_.addRow(rowData);
        this.webunitTableModel_.fireTableDataChanged();
    }

    public void updateData(List<WebUnitExecuteContext> contexts) throws Exception {
        this.webunitTableModel_.setDataVector((Object[][])null, TABLE_HEADERS);
        this.datas_ = contexts;
        if (contexts != null) {
            int counter = 0;
            for (WebUnitExecuteContext context : contexts) {
                Object[] rowData = new String[]{Integer.toString(counter), context.getRequest().getHeaders().getUri().getPathInfo(), ".....", Boolean.toString(context.hasError())};
                this.webunitTableModel_.addRow(rowData);
                ++counter;
            }
        }
        this.jtable_.getColumnModel().getColumn(0).setMaxWidth(5);
        this.webunitTableModel_.fireTableDataChanged();
    }

    static class TableRowColorRenderer
    extends DefaultTableCellRenderer {
        TableRowColorRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String cellValue = table.getValueAt(row, 3).toString();
            if ("true".equals(cellValue)) {
                this.setBackground(Color.red);
            } else {
                this.setBackground(table.getBackground());
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            }
            return this;
        }
    }

    public class WebunitExecuteContextPopupMenu
    extends JPopupMenu {
        public WebunitExecuteContextPopupMenu() {
            JMenuItem menuItem = new JMenuItem("View Parse Data");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        WebUnitExecuteContext rundata = HttpClientResultPanel.this.getSelectedRunData();
                        JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame("Webunit Data");
                        WebUnitDataViewPlugin view = new WebUnitDataViewPlugin();
                        String requestData = rundata.getRequest().getRequestDataAsText();
                        String responseData = rundata.getResponse().getResponseDataAsText();
                        view.setData(requestData, responseData);
                        frame.add(view);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.add(menuItem);
            menuItem = new JMenuItem("View Original Data");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        WebUnitExecuteContext rundata = HttpClientResultPanel.this.getSelectedRunData();
                        JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame("Webunit Orginal Data");
                        WebUnitDataViewPlugin view = new WebUnitDataViewPlugin();
                        String requestData = new String(rundata.getRequest().getOriginalRequestData());
                        String responseData = new String(rundata.getResponse().getOriginalResponseData());
                        view.setData(requestData, responseData);
                        frame.add(view);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.add(menuItem);
        }
    }

    public class RunDataCaptureListener
    implements WebUnitListener {
        public void onPreExecute(WebUnit unit, WebUnitExecuteContext context) throws Exception {
        }

        public void onPostExecute(WebUnit unit, WebUnitExecuteContext context) throws Exception {
            HttpClientResultPanel.this.addData(context);
        }
    }

    public class ClearWebunitsListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            HttpClientResultPanel.this.datas_.clear();
            HttpClientResultPanel.this.webunitTableModel_.setDataVector((Object[][])null, TABLE_HEADERS);
        }
    }

    public static class RunDataTableModel
    extends DefaultTableModel {
        public RunDataTableModel(Object[][] obj, String[] str) {
            super(obj, str);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

