/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api;

import java.io.Serializable;
import java.util.Locale;

public final class Mode
implements Serializable {
    private static final long serialVersionUID = 6033765240710422050L;
    public static final Mode EDIT = new Mode("edit");
    public static final Mode HELP = new Mode("help");
    public static final Mode VIEW = new Mode("view");
    public static final Mode EDIT_DEFAULTS = new Mode("edit_defaults");
    public static final Mode ADMIN = new Mode("admin");
    private String name;

    public Mode(String name) {
        this(name, false);
    }

    private Mode(String name, boolean preserveCase) {
        if (name == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.name = preserveCase ? name : name.toLowerCase(Locale.ENGLISH);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Mode) {
            Mode that = (Mode)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() {
        if (Mode.VIEW.name.equals(this.name)) {
            return VIEW;
        }
        if (Mode.EDIT.name.equals(this.name)) {
            return EDIT;
        }
        if (Mode.HELP.name.equals(this.name)) {
            return HELP;
        }
        if (Mode.EDIT_DEFAULTS.name.equals(this.name)) {
            return EDIT_DEFAULTS;
        }
        return this;
    }

    public static Mode create(String name) {
        return Mode.create(name, false);
    }

    public static Mode create(String name, boolean preserveCase) {
        if (Mode.VIEW.name.equals(name)) {
            return VIEW;
        }
        if (Mode.EDIT.name.equals(name)) {
            return EDIT;
        }
        if (Mode.HELP.name.equals(name)) {
            return HELP;
        }
        if (Mode.ADMIN.name.equals(name)) {
            return ADMIN;
        }
        if (Mode.EDIT_DEFAULTS.name.equals(name)) {
            return EDIT_DEFAULTS;
        }
        return new Mode(name, preserveCase);
    }
}

