/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import xjavadoc.AbstractClass;
import xjavadoc.AbstractExecutableMember;
import xjavadoc.ConstructorImpl;
import xjavadoc.MethodImpl;
import xjavadoc.Util;
import xjavadoc.XClass;
import xjavadoc.XJavaDoc;

final class BinaryClass
extends AbstractClass {
    public static int instanceCount = 0;
    private static final List _primitiveTypes = Arrays.asList("java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String");
    private final Class _clazz;
    private boolean _isSuperclassSet = false;
    private boolean _isInterfacesSet = false;

    public BinaryClass(XJavaDoc xJavaDoc, Class clazz) {
        super(xJavaDoc, null);
        this._clazz = clazz;
        this.setQualifiedName(clazz.getName());
        this.setContainingPackage(Util.getPackageNameFor(clazz.getName()));
        this.addModifier(clazz.getModifiers());
        if ("true".equals(System.getProperty("xjavadoc.compiledmethods"))) {
            this.setMethods(this._clazz);
            this.setConstructors(this._clazz);
        }
        ++instanceCount;
    }

    private static int getDimension(Class c) {
        return c.getName().lastIndexOf(91) + 1;
    }

    private static String getTypeName(Class c) {
        return c.getComponentType() != null ? c.getComponentType().getName() : c.getName();
    }

    public XClass getSuperclass() {
        this.setSuperclassMaybe();
        return super.getSuperclass();
    }

    public List getInterfaces() {
        this.setInterfacesMaybe();
        return super.getInterfaces();
    }

    public boolean isWriteable() {
        return false;
    }

    public boolean isImplementingInterface(String full_qualified_type_name, boolean superclasses) {
        return this.isClassImplementingInterface(this._clazz, full_qualified_type_name, superclasses);
    }

    public boolean isSubclassOf(String full_qualified_type_name, boolean superclasses) {
        Class superclass = this._clazz.getSuperclass();
        if (superclass == null) {
            return false;
        }
        do {
            if (superclass.getName().equals(full_qualified_type_name)) {
                return true;
            }
            superclass = superclass.getSuperclass();
        } while (superclasses && superclass != null);
        return false;
    }

    public boolean isPrimitive() {
        return _primitiveTypes.contains(this.getQualifiedName());
    }

    public void setDirty() {
    }

    public boolean saveNeeded() {
        return false;
    }

    private boolean isClassImplementingInterface(Class cur_class, String full_qualified_type_name, boolean superclasses) {
        do {
            Class<?>[] interfaces = cur_class.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> intf = interfaces[i];
                if (!intf.getName().equals(full_qualified_type_name) && !this.isClassImplementingInterface(intf, full_qualified_type_name, superclasses)) continue;
                return true;
            }
            cur_class = cur_class.getSuperclass();
        } while (superclasses && cur_class != null);
        return false;
    }

    private void setSuperclassMaybe() {
        if (!this._isSuperclassSet) {
            Class superclass = this._clazz.getSuperclass();
            if (superclass != null) {
                this.setSuperclass(superclass.getName());
            }
            this._isSuperclassSet = true;
        }
    }

    private void setInterfacesMaybe() {
        if (!this._isInterfacesSet) {
            Class<?>[] interfaces = this._clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addInterface(interfaces[i].getName());
            }
            this._isInterfacesSet = true;
        }
    }

    private void setConstructors(Class clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            ConstructorImpl constructor = new ConstructorImpl(this, null);
            constructor.addModifier(constructors[i].getModifiers());
            this.populateExecutableMember(constructor, constructors[i]);
            this.addConstructor(constructor);
        }
    }

    private void setMethods(Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if ("<clinit>".equals(methods[i].getName())) continue;
            MethodImpl method = new MethodImpl(this, null);
            method.setName(methods[i].getName());
            method.addModifier(methods[i].getModifiers());
            this.populateExecutableMember(method, methods[i]);
            Class<?> returnType = methods[i].getReturnType();
            String typeName = BinaryClass.getTypeName(returnType);
            int dimension = BinaryClass.getDimension(returnType);
            method.setReturnType(typeName);
            method.setReturnDimension(dimension);
            this.addMethod(method);
        }
    }

    private void populateExecutableMember(AbstractExecutableMember executableMember, AccessibleObject accessibleObject) {
        int i;
        Class<?>[] exceptions;
        Class<?>[] parameters;
        if (accessibleObject instanceof Constructor) {
            parameters = ((Constructor)accessibleObject).getParameterTypes();
            exceptions = ((Constructor)accessibleObject).getExceptionTypes();
        } else {
            parameters = ((Method)accessibleObject).getParameterTypes();
            exceptions = ((Method)accessibleObject).getExceptionTypes();
        }
        for (i = parameters.length - 1; i >= 0; --i) {
            String typeName = BinaryClass.getTypeName(parameters[i]);
            int dimension = BinaryClass.getDimension(parameters[i]);
            executableMember.addParameterData(typeName, "p" + i, dimension);
        }
        for (i = exceptions.length - 1; i >= 0; --i) {
            executableMember.addThrownException(exceptions[i].getName());
        }
    }
}

