/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.proxy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.common.http.client.ProtocolNotSuppException;
import org.exoplatform.services.rest.ext.proxy.BaseConnector;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="proxy")
public class ProxyService
implements ResourceContainer {
    @GET
    public Response doProxyGet(@Context HttpServletRequest httpRequest, @QueryParam(value="url") String url) {
        BaseConnector conn = new BaseConnector();
        if (url == null) {
            Throwable e = new Throwable("Necessary URL parameter not found in proxy request");
            throw new WebApplicationException(e, this.createErrorResponse(e, 404));
        }
        try {
            HTTPResponse resp = conn.fetchGet(httpRequest, url);
            return this.createResponse(resp);
        }
        catch (MalformedURLException mue) {
            throw new WebApplicationException((Throwable)mue, this.createErrorResponse(mue, 400));
        }
        catch (ProtocolNotSuppException pnse) {
            throw new WebApplicationException((Throwable)pnse, this.createErrorResponse(pnse, 400));
        }
        catch (IOException ioe) {
            throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 500));
        }
        catch (ParseException pe) {
            throw new WebApplicationException((Throwable)pe, this.createErrorResponse(pe, 400));
        }
    }

    @POST
    public Response doProxyPost(@Context HttpServletRequest httpRequest, @QueryParam(value="url") String url) {
        BaseConnector conn = new BaseConnector();
        if (url == null) {
            Throwable e = new Throwable("Necessary URL parameter not found in proxy request");
            throw new WebApplicationException(e, this.createErrorResponse(e, 404));
        }
        try {
            HTTPResponse resp = conn.fetchPost(httpRequest, url);
            return this.createResponse(resp);
        }
        catch (MalformedURLException mue) {
            throw new WebApplicationException((Throwable)mue, this.createErrorResponse(mue, 400));
        }
        catch (ProtocolNotSuppException pnse) {
            throw new WebApplicationException((Throwable)pnse, this.createErrorResponse(pnse, 400));
        }
        catch (IOException ioe) {
            throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 500));
        }
        catch (ParseException pe) {
            throw new WebApplicationException((Throwable)pe, this.createErrorResponse(pe, 400));
        }
    }

    @PUT
    public Response doProxyPut(@Context HttpServletRequest httpRequest, @QueryParam(value="url") String url) {
        BaseConnector conn = new BaseConnector();
        if (url == null) {
            Throwable e = new Throwable("Necessary URL parameter not found in proxy request");
            throw new WebApplicationException(e, this.createErrorResponse(e, 404));
        }
        try {
            HTTPResponse resp = conn.doPut(httpRequest, url);
            return this.createResponse(resp);
        }
        catch (MalformedURLException mue) {
            throw new WebApplicationException((Throwable)mue, this.createErrorResponse(mue, 400));
        }
        catch (ProtocolNotSuppException pnse) {
            throw new WebApplicationException((Throwable)pnse, this.createErrorResponse(pnse, 400));
        }
        catch (IOException ioe) {
            throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 500));
        }
        catch (ParseException pe) {
            throw new WebApplicationException((Throwable)pe, this.createErrorResponse(pe, 400));
        }
    }

    @DELETE
    public Response doProxyDelete(@Context HttpServletRequest httpRequest, @QueryParam(value="url") String url) {
        BaseConnector conn = new BaseConnector();
        if (url == null) {
            Throwable e = new Throwable("Necessary URL parameter not found in proxy request");
            throw new WebApplicationException(e, this.createErrorResponse(e, 404));
        }
        try {
            HTTPResponse resp = conn.doDelete(httpRequest, url);
            return this.createResponse(resp);
        }
        catch (MalformedURLException mue) {
            throw new WebApplicationException((Throwable)mue, this.createErrorResponse(mue, 400));
        }
        catch (ProtocolNotSuppException pnse) {
            throw new WebApplicationException((Throwable)pnse, this.createErrorResponse(pnse, 400));
        }
        catch (IOException ioe) {
            throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 500));
        }
        catch (ParseException pe) {
            throw new WebApplicationException((Throwable)pe, this.createErrorResponse(pe, 400));
        }
    }

    private Response createResponse(HTTPResponse httpResponse) {
        try {
            Response.ResponseBuilder responseBuilder = Response.status((int)httpResponse.getStatusCode());
            Enumeration en = httpResponse.listHeaders();
            while (en.hasMoreElements()) {
                String headerName = (String)en.nextElement();
                responseBuilder.header(headerName, (Object)httpResponse.getHeader(headerName));
            }
            return responseBuilder.entity((Object)httpResponse.getInputStream()).build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 400));
        }
    }

    private Response createErrorResponse(Throwable t, int status) {
        return Response.status((int)status).entity((Object)t.getMessage()).type("text/plain").build();
    }
}

