/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.ha.framework.server.PojoCacheManager;
import org.jboss.ha.framework.server.PojoCacheManagerLocator;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.AbstractJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBasedJBossCacheService
extends AbstractJBossCacheService<OutgoingDistributableSessionData> {
    public static final String ATTRIBUTE = "ATTRIBUTE";
    private final PojoCache pojoCache_;

    public static Fqn<String> getAttributeFqn(String contextHostPath, String sessionId) {
        String[] objs = new String[]{"JSESSION", contextHostPath, sessionId, ATTRIBUTE};
        return Fqn.fromList(Arrays.asList(objs), (boolean)true);
    }

    public static Fqn<String> getFieldFqn(String contextHostPath, String sessionId, String attributeKey) {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("JSESSION");
        list.add(contextHostPath);
        list.add(sessionId);
        list.add(ATTRIBUTE);
        FieldBasedJBossCacheService.breakKeys(attributeKey, list);
        return Fqn.fromList(list, (boolean)true);
    }

    private static void breakKeys(String key, List<String> list) {
        StringTokenizer token = new StringTokenizer(key, "/");
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
    }

    public FieldBasedJBossCacheService(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        this(localManager, Util.findPojoCache(Util.getCacheConfigName(localManager)));
        this.cacheConfigName_ = Util.getCacheConfigName(localManager);
    }

    public FieldBasedJBossCacheService(LocalDistributableSessionManager localManager, PojoCache cache) {
        super(localManager, (Cache<Object, Object>)cache.getCache());
        this.pojoCache_ = cache;
        if (!this.isMarshallingAvailable()) {
            throw new IllegalStateException("replication-granularity value is set to 'FIELD' but is not supported by the cache service configuration. Must set 'useRegionBasedMarshalling' to 'true' in the cache configuration");
        }
    }

    public boolean getSupportsAttributeOperations() {
        return true;
    }

    public void putAttribute(String realId, String key, Object value) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("putAttribute(): session id: " + realId + " key: " + key + " object: " + value.toString()));
        }
        Fqn<String> fqn = FieldBasedJBossCacheService.getFieldFqn(this.combinedPath_, realId, key);
        try {
            this.pojoCache_.attach(fqn.toString(), value);
        }
        catch (CacheException e) {
            throw new RuntimeException("Exception occurred in PojoCache attach ... ", e);
        }
    }

    public Object removeAttribute(String realId, String key) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("removePojo(): session id: " + realId + " key: " + key));
        }
        Fqn<String> fqn = FieldBasedJBossCacheService.getFieldFqn(this.combinedPath_, realId, key);
        try {
            return this.pojoCache_.detach(fqn.toString());
        }
        catch (CacheException e) {
            throw new RuntimeException("Exception occurred in PojoCache detach ... ", e);
        }
    }

    public void removeAttributeLocal(String realId, String key) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("removePojoLocal(): session id: " + realId + " key: " + key));
        }
        Fqn<String> fqn = FieldBasedJBossCacheService.getFieldFqn(this.combinedPath_, realId, key);
        this.cacheWrapper_.removeLocal(fqn);
    }

    public Set<String> getAttributeKeys(String realId) {
        Set<String> keys = null;
        Fqn<String> fqn = FieldBasedJBossCacheService.getAttributeFqn(this.combinedPath_, realId);
        try {
            keys = this.getChildrenNames(fqn);
        }
        catch (CacheException e) {
            this.log_.error((Object)("getAttributeKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Object getAttribute(String realId, String key) {
        Fqn<String> fqn = FieldBasedJBossCacheService.getFieldFqn(this.combinedPath_, realId, key);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("getPojo(): session id: " + realId + " key: " + key + " fqn: " + fqn));
        }
        try {
            return this.pojoCache_.find(fqn);
        }
        catch (CacheException e) {
            throw new RuntimeException("Exception occurred in PojoCache find ... ", e);
        }
    }

    @Override
    public void sessionCreated(String realId) {
        Fqn<String> fqn = FieldBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        this.setupSessionRegion(fqn);
    }

    @Override
    protected void setupSessionRegion(Fqn<String> fqn) {
        this.getCache().getRegion(fqn, true);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Created region for session at " + fqn));
        }
    }

    @Override
    protected void removeSessionRegion(String realId, Fqn<String> fqn) {
        this.getCache().removeRegion(fqn);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Removed region for session at " + fqn));
        }
    }

    @Override
    protected void releaseCacheToManager(String cacheConfigName) {
        try {
            PojoCacheManager pcm = PojoCacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
            pcm.releaseCache(cacheConfigName);
        }
        catch (Exception e) {
            this.log_.error((Object)("Problem releasing cache to CacheManager -- config is " + cacheConfigName), (Throwable)e);
        }
    }

    public Map<String, Object> getAttributes(String realId) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Set<String> keys = this.getAttributeKeys(realId);
        for (String key : keys) {
            attrs.put(key, this.getAttribute(realId, key));
        }
        return attrs;
    }

    public void putAttribute(String realId, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.putAttribute(realId, entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected Map<String, Object> getSessionAttributes(String realId, Map<Object, Object> distributedCacheData) {
        return this.getAttributes(realId);
    }

    @Override
    protected void storeSessionAttributes(Map<Object, Object> dataMap, OutgoingDistributableSessionData sessionData) {
    }
}

