/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    private final Log log;
    private final String poolName;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final boolean daemon;

    public LoggingThreadFactory(String poolName, boolean daemon) {
        this.poolName = poolName;
        this.log = LogFactory.getLog((String)("org.jboss.on.threadpools." + poolName));
        this.daemon = daemon;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.poolName + "-" + this.threadNumber.getAndIncrement());
        t.setDaemon(this.daemon);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setUncaughtExceptionHandler(this);
        return t;
    }

    public void uncaughtException(Thread t, Throwable e) {
        this.log.error((Object)("Uncaught exception on scheduled thread [" + t.getName() + "]"), e);
    }
}

