/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.rmi.RemoteException;
import javax.transaction.Transaction;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.proxy.ejb.ForeignTransaction;

public class NoTxPropagationInterceptor
extends AbstractInterceptor {
    public Object invokeHome(Invocation mi) throws Exception {
        this.checkNoTxPropagation(mi);
        return this.getNext().invokeHome(mi);
    }

    public Object invoke(Invocation mi) throws Exception {
        this.checkNoTxPropagation(mi);
        return this.getNext().invoke(mi);
    }

    protected void checkNoTxPropagation(Invocation mi) throws Exception {
        if (mi.isLocal()) {
            return;
        }
        Transaction tx = mi.getTransaction();
        if (tx == null || !(tx instanceof ForeignTransaction)) {
            return;
        }
        byte txType = this.container.getBeanMetaData().getTransactionMethod(mi.getMethod(), mi.getType());
        if (txType != 0 && txType != 3) {
            throw new RemoteException("TxPropagation is not supported: " + this.container.getJmxName() + " method=" + mi.getMethod());
        }
        mi.setTransaction(null);
    }
}

