/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ActivationPolicy;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.management.AbstractRuntimeComponentDispatcher;
import org.jboss.profileservice.management.AbstractTemplateCreator;
import org.jboss.profileservice.management.ManagedOperationProxyFactory;
import org.jboss.profileservice.management.views.AbstractProfileView;
import org.jboss.profileservice.management.views.BootstrapProfileView;
import org.jboss.profileservice.management.views.PlatformMbeansView;
import org.jboss.profileservice.management.views.ProfileView;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.profileservice.attachments.AttachmentStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingManagementView
extends AbstractTemplateCreator
implements ManagementView {
    private static final Logger log = Logger.getLogger(AggregatingManagementView.class);
    private static final String BUNDLE_NAME = "org.jboss.profileservice.management.messages";
    private ResourceBundle i18n;
    private Locale currentLocale;
    private MessageFormat formatter = new MessageFormat("");
    private ProfileService ps;
    private RuntimeComponentDispatcher dispatcher;
    private ManagedOperationProxyFactory proxyFactory;
    private MainDeployer mainDeployer;
    private AttachmentStore store;
    private Map<String, ManagedDeployment> bootstrapManagedDeployments = Collections.emptyMap();
    private HashMap<String, DeploymentTemplate> templates = new HashMap();
    private Map<ProfileKey, AbstractProfileView> profileViews = new ConcurrentHashMap<ProfileKey, AbstractProfileView>();

    public AggregatingManagementView() {
        this.currentLocale = Locale.getDefault();
        this.formatter.setLocale(this.currentLocale);
        this.i18n = ResourceBundle.getBundle(BUNDLE_NAME, this.currentLocale);
    }

    public RuntimeComponentDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(RuntimeComponentDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
    }

    public ManagedOperationProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public void setProxyFactory(ManagedOperationProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public AttachmentStore getAttachmentStore() {
        return this.store;
    }

    public void setAttachmentStore(AttachmentStore store) {
        this.store = store;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public Map<String, ManagedDeployment> getBootstrapManagedDeployments() {
        return this.bootstrapManagedDeployments;
    }

    public void setBootstrapManagedDeployments(Map<String, ManagedDeployment> bootstrapManagedDeployments) {
        this.bootstrapManagedDeployments = bootstrapManagedDeployments;
    }

    public void start() throws Exception {
        if (this.proxyFactory == null) {
            throw new IllegalStateException("proxy factory not injected");
        }
        this.addView(new PlatformMbeansView(this.proxyFactory));
        if (this.bootstrapManagedDeployments != null) {
            this.addView(new BootstrapProfileView(this.proxyFactory, this.bootstrapManagedDeployments.values()));
        }
    }

    public boolean load() {
        return this.loadProfiles(false);
    }

    public void reload() {
        this.loadProfiles(true);
    }

    public void process() throws Exception {
    }

    public void addView(AbstractProfileView view) {
        if (view == null) {
            throw new IllegalArgumentException("null view");
        }
        if (view.getProfileKey() == null) {
            throw new IllegalArgumentException("null profile key");
        }
        this.profileViews.put(view.getProfileKey(), view);
        log.debug((Object)("add view: " + view));
    }

    public void removeView(AbstractProfileView view) {
        if (view == null) {
            throw new IllegalArgumentException("null view");
        }
        if (view.getProfileKey() == null) {
            throw new IllegalArgumentException("null profile key");
        }
        this.profileViews.remove(view.getProfileKey());
        log.debug((Object)("remove view: " + view));
    }

    public void addTemplate(DeploymentTemplate template) {
        this.templates.put(template.getInfo().getName(), template);
        log.debug((Object)("addTemplate: " + template));
    }

    public void removeTemplate(DeploymentTemplate template) {
        this.templates.remove(template.getInfo().getName());
        log.debug((Object)("removeTemplate: " + template));
    }

    public void applyTemplate(String deploymentBaseName, DeploymentTemplateInfo info) throws Exception {
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null deployment base name.");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null template info.");
        }
        DeploymentTemplate template = this.templates.get(info.getName());
        if (template == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
            Object[] args = new Object[]{info.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("applyTemplate, deploymentBaseName=" + deploymentBaseName + ", info=" + info));
        }
        super.applyTemplate(template, deploymentBaseName, info);
        this.profileViews.put(this.getDefaulProfiletKey(), this.createProfileView(this.getDefaulProfiletKey()));
    }

    public ManagedComponent getComponent(String name, ComponentType type) throws Exception {
        Set<ManagedComponent> components = this.getComponentsForType(type);
        ManagedComponent comp = null;
        if (components != null) {
            for (ManagedComponent mc : components) {
                if (!mc.getName().equals(name)) continue;
                comp = mc;
                break;
            }
        }
        if (comp != null) {
            Map props = comp.getProperties();
            Set ops = comp.getOperations();
            log.debug((Object)("Component(ops.size=" + ops != null ? ops.size() : ("0,props.size=)" + props != null ? props.size() : 0)));
        }
        return comp;
    }

    public Set<ComponentType> getComponentTypes() {
        HashSet<ComponentType> componentTypes = new HashSet<ComponentType>();
        for (AbstractProfileView view : this.profileViews.values()) {
            componentTypes.addAll(view.getComponentTypes());
        }
        return componentTypes;
    }

    public Set<ManagedComponent> getComponentsForType(ComponentType type) throws Exception {
        HashSet<ManagedComponent> components = new HashSet<ManagedComponent>();
        for (AbstractProfileView view : this.profileViews.values()) {
            components.addAll(view.getComponentsForType(type));
        }
        return components;
    }

    public ManagedDeployment getDeployment(String name) throws NoSuchDeploymentException {
        ArrayList<ManagedDeployment> deployments = new ArrayList<ManagedDeployment>();
        for (AbstractProfileView view : this.profileViews.values()) {
            deployments.addAll(view.getDeployment(name));
        }
        if (deployments.size() == 0) {
            throw new NoSuchDeploymentException(name);
        }
        if (deployments.size() > 1) {
            throw new NoSuchDeploymentException("multiple matching deployments found for name: " + name + ", available: " + deployments);
        }
        return (ManagedDeployment)deployments.get(0);
    }

    public Set<String> getDeploymentNames() {
        TreeSet<String> deploymentNames = new TreeSet<String>();
        for (AbstractProfileView view : this.profileViews.values()) {
            deploymentNames.addAll(view.getDeploymentNames());
        }
        return deploymentNames;
    }

    public Set<String> getDeploymentNamesForType(String type) {
        TreeSet<String> deploymentNames = new TreeSet<String>();
        for (AbstractProfileView view : this.profileViews.values()) {
            deploymentNames.addAll(view.getDeploymentNamesForType(type));
        }
        return deploymentNames;
    }

    public Set<ManagedDeployment> getDeploymentsForType(String type) throws Exception {
        HashSet<ManagedDeployment> deployments = new HashSet<ManagedDeployment>();
        for (AbstractProfileView view : this.profileViews.values()) {
            deployments.addAll(view.getDeploymentsForType(type));
        }
        return deployments;
    }

    public Set<ManagedComponent> getMatchingComponents(String name, ComponentType type, NameMatcher<ManagedComponent> matcher) throws Exception {
        Set<ManagedComponent> components = this.getComponentsForType(type);
        HashSet<ManagedComponent> matched = new HashSet<ManagedComponent>();
        if (components != null) {
            for (ManagedComponent mc : components) {
                if (!matcher.matches((Object)mc, name)) continue;
                matched.add(mc);
            }
        }
        if (matched.size() > 0) {
            log.debug((Object)("getComponents matched: " + matched));
        }
        return matched;
    }

    public Set<String> getMatchingDeploymentName(String regex) throws NoSuchDeploymentException {
        Set<String> names = this.getDeploymentNames();
        HashSet<String> matches = new HashSet<String>();
        Pattern p = Pattern.compile(regex);
        for (String name : names) {
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            matches.add(name);
        }
        if (matches.size() == 0) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
            Object[] args = new Object[]{regex};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        return matches;
    }

    public Set<ManagedDeployment> getMatchingDeployments(String name, NameMatcher<ManagedDeployment> matcher) throws NoSuchDeploymentException, Exception {
        return new HashSet<ManagedDeployment>();
    }

    public DeploymentTemplateInfo getTemplate(String name) throws NoSuchDeploymentException {
        DeploymentTemplate template = this.templates.get(name);
        if (template == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        DeploymentTemplateInfo info = template.getInfo();
        info = info.copy();
        log.debug((Object)("getTemplate, " + info));
        return info;
    }

    public Set<String> getTemplateNames() {
        return new HashSet<String>(this.templates.keySet());
    }

    public void removeComponent(ManagedComponent comp) throws Exception {
        if (comp == null) {
            throw new IllegalArgumentException("null managed component.");
        }
        ManagedDeployment md = comp.getDeployment();
        while (md.getParent() != null) {
            md = md.getParent();
        }
        String name = md.getName();
        ProfileDeployment profileDeployment = this.getProfileDeployment(name);
        if (profileDeployment == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        ManagedDeployment compMD = this.getDeployment(md.getName());
        log.debug((Object)("updateComponent, deploymentName=" + name + ": " + compMD));
        ManagedComponent serverComp = null;
        if (comp.getDeployment().getParent() == null) {
            serverComp = compMD.getComponent(comp.getName());
        } else if (compMD.getChildren() != null && !compMD.getChildren().isEmpty()) {
            for (ManagedDeployment child : compMD.getChildren()) {
                if (serverComp != null) break;
                serverComp = child.getComponent(comp.getName());
            }
        }
        if (serverComp == null) {
            log.debug((Object)("Name: " + comp.getName() + " does not map to existing ManagedComponet in ManagedDeployment: " + md.getName() + ", components: " + compMD.getComponents()));
            this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidComponentName"));
            Object[] args = new Object[]{comp.getName(), md.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalArgumentException(msg);
        }
        log.debug((Object)("remove component: " + comp + ", deployment: " + profileDeployment));
        Profile profile = this.getProfileForDeployment(md.getName());
        this.store.removeComponent(comp.getDeployment().getName(), serverComp);
        this.profileViews.put(profile.getKey(), this.createProfileView(profile));
    }

    public void updateComponent(ManagedComponent comp) throws Exception {
        if (comp == null) {
            throw new IllegalArgumentException("Null managed component.");
        }
        ManagedDeployment md = comp.getDeployment();
        while (md.getParent() != null) {
            md = md.getParent();
        }
        String name = md.getName();
        ProfileDeployment compDeployment = this.getProfileDeployment(name);
        if (compDeployment == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        ManagedDeployment compMD = this.getDeployment(md.getName());
        log.debug((Object)("updateComponent, deploymentName=" + name + ": " + compMD));
        ManagedComponent serverComp = null;
        if (comp.getDeployment().getParent() == null) {
            serverComp = compMD.getComponent(comp.getName());
        } else if (compMD.getChildren() != null && !compMD.getChildren().isEmpty()) {
            for (ManagedDeployment child : compMD.getChildren()) {
                if (serverComp != null) break;
                serverComp = child.getComponent(comp.getName());
            }
        }
        if (serverComp == null) {
            log.debug((Object)("Name: " + comp.getName() + " does not map to existing ManagedComponet in ManagedDeployment: " + md.getName() + ", components: " + compMD.getComponents()));
            this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidComponentName"));
            Object[] args = new Object[]{comp.getName(), md.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalArgumentException(msg);
        }
        for (ManagedProperty prop : comp.getProperties().values()) {
            String mappedName;
            boolean skip;
            boolean bl = skip = prop.getValue() == null || prop.isReadOnly() || !prop.hasViewUse(ViewUse.CONFIGURATION) || prop.isRemoved();
            if (skip) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Skipping component property: " + prop));
                continue;
            }
            ManagedProperty ctxProp = (ManagedProperty)serverComp.getProperties().get(prop.getName());
            if (ctxProp == null && (mappedName = prop.getMappedName()) != null) {
                ctxProp = (ManagedProperty)serverComp.getProperties().get(mappedName);
            }
            if (ctxProp == null) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplateProperty"));
                Object[] args = new Object[]{prop.getName()};
                String msg = this.formatter.format(args);
                throw new IllegalArgumentException(msg);
            }
            MetaValue value = prop.getValue();
            if (!(value instanceof MetaValue)) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidPropertyValue"));
                Object[] args = new Object[]{prop.getName(), value.getClass()};
                String msg = this.formatter.format(args);
                throw new IllegalArgumentException(msg);
            }
            MetaValue metaValue = value;
            ctxProp.setField("metaType", (Serializable)metaValue.getMetaType());
            ctxProp.setValue(metaValue);
            Object componentName = this.getComponentName(ctxProp);
            ActivationPolicy policy = ctxProp.getActivationPolicy();
            if (componentName == null || !policy.equals((Object)ActivationPolicy.IMMEDIATE)) continue;
            AbstractRuntimeComponentDispatcher.setActiveProperty(ctxProp);
            this.dispatcher.set(componentName, ctxProp.getName(), metaValue);
        }
        Profile profile = this.getProfileForDeployment(md.getName());
        this.store.updateDeployment(comp.getDeployment().getName(), serverComp);
        this.profileViews.put(profile.getKey(), this.createProfileView(profile));
    }

    protected boolean loadProfiles(boolean forceReload) {
        boolean wasReloaded = false;
        Collection activeProfiles = this.ps.getActiveProfileKeys();
        for (ProfileKey key : activeProfiles) {
            if (!this.loadProfile(key, forceReload)) continue;
            wasReloaded = true;
        }
        return wasReloaded;
    }

    protected boolean loadProfile(ProfileKey key, boolean forceReload) {
        boolean wasModified = false;
        try {
            Profile profile = this.ps.getActiveProfile(key);
            AbstractProfileView view = this.profileViews.get(profile.getKey());
            boolean bl = wasModified = forceReload || view == null || view.hasBeenModified(profile);
            if (wasModified) {
                this.profileViews.put(key, this.createProfileView(profile));
                wasModified = true;
            }
        }
        catch (NoSuchProfileException e) {
            wasModified = this.profileViews.remove(key) != null;
            log.debug((Object)("Failed to load profile " + key));
        }
        return wasModified;
    }

    protected AbstractProfileView createProfileView(ProfileKey key) throws NoSuchProfileException {
        Profile profile = this.ps.getActiveProfile(key);
        return this.createProfileView(profile);
    }

    protected AbstractProfileView createProfileView(Profile profile) {
        return new ProfileView(profile, this.proxyFactory, this.mainDeployer);
    }

    protected Object getComponentName(ManagedProperty property) {
        ManagedObject targetObject = property.getTargetManagedObject();
        if (targetObject != null) {
            return targetObject.getComponentName();
        }
        targetObject = property.getManagedObject();
        return targetObject != null ? targetObject.getComponentName() : null;
    }

    private ProfileKey getProfileKeyForDeployemnt(String name) throws NoSuchDeploymentException {
        ManagedDeployment md = this.getDeployment(name);
        return (ProfileKey)md.getAttachment(ProfileKey.class);
    }

    private Profile getProfileForDeployment(String name) throws Exception {
        ProfileKey key = this.getProfileKeyForDeployemnt(name);
        if (key == null) {
            throw new NoSuchDeploymentException("No associated profile found for deployment:" + name);
        }
        return this.ps.getActiveProfile(key);
    }

    private ProfileDeployment getProfileDeployment(String name) throws Exception {
        Profile profile = this.getProfileForDeployment(name);
        return profile.getDeployment(name);
    }
}

