/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeoutException;
import org.jboss.aspects.asynchronous.AsynchronousConstants;
import org.jboss.aspects.asynchronous.AsynchronousParameters;
import org.jboss.aspects.asynchronous.AsynchronousUserTask;
import org.jboss.aspects.asynchronous.ProcessingTime;
import org.jboss.aspects.asynchronous.ThreadManagerResponse;
import org.jboss.aspects.asynchronous.common.ThreadManagerResponseImpl;
import org.jboss.aspects.asynchronous.concurrent.AdapterTask;
import org.jboss.aspects.asynchronous.concurrent.AsynchronousTask;
import org.jboss.aspects.asynchronous.concurrent.TimedCallableImpl;

public final class AsynchronousTaskImpl
implements AsynchronousConstants,
AsynchronousTask {
    private long _timeout = 0L;
    private AsynchronousParameters _inputParametersImpl = null;
    private AsynchronousUserTask _oneInstance = null;
    private FutureTask _futureResult = null;
    private Callable _callable = null;
    private String _id = null;

    AsynchronousTaskImpl(String id, String taskImpl, AsynchronousParameters inputParametersImpl, long timeout) {
        this._id = id;
        this._timeout = timeout;
        this._inputParametersImpl = inputParametersImpl;
        try {
            Class<?> aClass = Class.forName(taskImpl);
            this._oneInstance = (AsynchronousUserTask)aClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    AsynchronousTaskImpl(String id, AsynchronousUserTask userTask, AsynchronousParameters inputParametersImpl, long timeout) {
        this._id = id;
        this._timeout = timeout;
        this._oneInstance = userTask;
        this._inputParametersImpl = inputParametersImpl;
    }

    public AsynchronousParameters getInputParameters() {
        return this._inputParametersImpl;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public AsynchronousUserTask getTask() {
        return this._oneInstance;
    }

    public ThreadManagerResponse getResponse() {
        try {
            if (this.isDone()) {
                return (ThreadManagerResponse)this._futureResult.get();
            }
            Object value = this._futureResult.get();
            if (value != null) {
                return (ThreadManagerResponse)value;
            }
            return new ThreadManagerResponseImpl(this.getId(), 40, null, null);
        }
        catch (InterruptedException e) {
            return new ThreadManagerResponseImpl(this.getId(), 50, e.getMessage(), e, this.getStartingTime(), this.getEndingTime());
        }
        catch (ExecutionException e) {
            int errorCode = 30;
            if (e.getCause() instanceof TimeoutException) {
                errorCode = 10;
            }
            return new ThreadManagerResponseImpl(this.getId(), errorCode, e.getCause().getMessage(), e.getCause(), this.getStartingTime(), this.getEndingTime());
        }
    }

    public long getStartingTime() {
        return ((ProcessingTime)((Object)this._callable)).getStartingTime();
    }

    public long getEndingTime() {
        return ((ProcessingTime)((Object)this._callable)).getEndingTime();
    }

    public boolean isDone() {
        return this._futureResult.isDone();
    }

    public Runnable add() throws Exception {
        this._callable = this._timeout == 0L ? new AdapterTask(this.getId(), this._inputParametersImpl, this._oneInstance) : new TimedCallableImpl(new AdapterTask(this.getId(), this._inputParametersImpl, this._oneInstance), this._timeout);
        this._futureResult = new FutureTask(this._callable);
        return this._futureResult;
    }

    public String getId() {
        return this._id;
    }
}

