/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedComponentUtils {
    public static ManagedComponent getManagedComponent(ManagementView managementView, ComponentType componentType, String componentName) {
        Set<ManagedComponent> components = ManagedComponentUtils.getManagedComponents(managementView, componentType);
        for (ManagedComponent component : components) {
            if (!component.getName().equals(componentName)) continue;
            return component;
        }
        return null;
    }

    public static ManagedComponent getSingletonManagedComponent(ManagementView managementView, ComponentType componentType) {
        Set<ManagedComponent> components = ManagedComponentUtils.getManagedComponents(managementView, componentType);
        if (components.size() != 1) {
            throw new IllegalStateException("Found more than one component of type " + componentType + ": " + components);
        }
        ManagedComponent component = components.iterator().next();
        return component;
    }

    public static Serializable getSimplePropertyValue(ManagedComponent component, String propertyName) {
        Object value;
        ManagedProperty property = component.getProperty(propertyName);
        if (property == null) {
            throw new IllegalStateException("Property named '" + propertyName + "' not found for ManagedComponent [" + component + "].");
        }
        MetaType metaType = property.getMetaType();
        if (metaType.isSimple()) {
            SimpleValue simpleValue = (SimpleValue)property.getValue();
            value = simpleValue != null ? simpleValue.getValue() : null;
        } else if (metaType.isEnum()) {
            EnumValue enumValue = (EnumValue)property.getValue();
            value = enumValue != null ? enumValue.getValue() : null;
        } else {
            throw new IllegalStateException("Type of [" + property + "] is not simple or enum.");
        }
        return value;
    }

    @NotNull
    public static EnumSet<ViewUse> getViewUses(ManagedProperty managedProperty) {
        EnumSet<ViewUse> viewUses = EnumSet.noneOf(ViewUse.class);
        for (ViewUse viewUse : ViewUse.values()) {
            if (!managedProperty.hasViewUse(viewUse)) continue;
            viewUses.add(viewUse);
        }
        return viewUses;
    }

    public static boolean isManagedComponent(ManagementView managementView, String name, ComponentType componentType) {
        boolean isDeployed = false;
        if (name != null) {
            try {
                ManagedComponent component = ManagedComponentUtils.getManagedComponent(managementView, componentType, name);
                if (component != null) {
                    isDeployed = true;
                }
            }
            catch (Exception e) {
                isDeployed = true;
            }
        }
        return isDeployed;
    }

    @NotNull
    private static Set<ManagedComponent> getManagedComponents(ManagementView managementView, ComponentType componentType) {
        Set components;
        try {
            components = managementView.getComponentsForType(componentType);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return components;
    }
}

