/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.Permission;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.LoggerNode;

public final class LogContext {
    private static final LogContext SYSTEM_CONTEXT = new LogContext();
    private static final Permission CREATE_CONTEXT_PERMISSION = new RuntimePermission("createLogContext", null);
    private static final Permission SET_CONTEXT_SELECTOR_PERMISSION = new RuntimePermission("setLogContextSelector", null);
    private static final Permission CONTROL_PERMISSION = new LoggingPermission("control", null);
    private final LoggerNode rootLogger = new LoggerNode(this);
    final Lock levelTreeLock = new ReentrantLock(false);
    private static volatile LogContextSelector logContextSelector = new LogContextSelector(){

        public LogContext getLogContext() {
            return SYSTEM_CONTEXT;
        }
    };

    LogContext() {
    }

    public static LogContext create() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CONTEXT_PERMISSION);
        }
        return new LogContext();
    }

    public Logger getLogger(String name) {
        return this.rootLogger.getOrCreate(name).getOrCreateLogger();
    }

    public static LogContext getSystemLogContext() {
        return SYSTEM_CONTEXT;
    }

    public static LogContext getLogContext() {
        return logContextSelector.getLogContext();
    }

    public static void setLogContextSelector(LogContextSelector newSelector) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT_SELECTOR_PERMISSION);
        }
        logContextSelector = newSelector;
    }

    void checkAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
    }
}

