/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public final class IOUtils {
    private IOUtils() {
    }

    public static Writer getCharsetFileWriter(File file, String charset) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
    }

    public static void copyStream(OutputStream outs, InputStream ins) throws IOException {
        try {
            byte[] bytes = new byte[1024];
            int r = ins.read(bytes);
            while (r > 0) {
                outs.write(bytes, 0, r);
                r = ins.read(bytes);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            ins.close();
        }
    }

    public static void copyReader(OutputStream outs, Reader reader) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outs);
            char[] bytes = new char[1024];
            int r = reader.read(bytes);
            while (r > 0) {
                writer.write(bytes, 0, r);
                r = reader.read(bytes);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.close();
        }
    }

    public static byte[] convertToBytes(DataHandler dh) {
        try {
            ByteArrayOutputStream buffOS = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)buffOS);
            return buffOS.toByteArray();
        }
        catch (IOException e) {
            throw new WebServiceException("Unable to convert DataHandler to byte[]: " + e.getMessage());
        }
    }

    public static InputStream transformReader(Reader reader) throws IOException {
        try {
            int capacity = 1024;
            char[] charBuffer = new char[capacity];
            StringBuffer strBuffer = new StringBuffer(capacity);
            int len = reader.read(charBuffer, 0, capacity);
            while (len > 0) {
                strBuffer.append(charBuffer, 0, len);
                len = reader.read(charBuffer, 0, capacity);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(strBuffer.toString().getBytes());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.close();
        }
    }

    public static File createTempDirectory() throws IOException {
        File tmpdir = null;
        try {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
            tmpdir = new File(config.getServerTempDir().getCanonicalPath() + "/jbossws");
            tmpdir.mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tmpdir;
    }
}

