/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UIListShuttle;
import org.richfaces.component.UIOrderingBaseComponent;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.model.ListShuttleRowKey;
import org.richfaces.renderkit.ListShuttleControlsHelper;
import org.richfaces.renderkit.OrderingComponentControlsHelper;
import org.richfaces.renderkit.OrderingComponentRendererBase;
import org.richfaces.renderkit.OrderingListRendererBase;
import org.richfaces.renderkit.TableHolder;

public abstract class ListShuttleRendererBase
extends OrderingComponentRendererBase {
    protected static final String SELECTION_STATE_VAR_NAME = "selectionState";
    public static final String FACET_SOURCE_CAPTION = "sourceCaption";
    public static final String FACET_TARGET_CAPTION = "targetCaption";
    protected static final OrderingComponentRendererBase.ControlsHelper[] SHUTTLE_HELPERS = ListShuttleControlsHelper.HELPERS;
    protected static final OrderingComponentRendererBase.ControlsHelper[] TL_HELPERS = OrderingComponentControlsHelper.HELPERS;
    private static final String MESSAGE_BUNDLE_NAME = OrderingListRendererBase.class.getPackage().getName() + ".listShuttle";

    public ListShuttleRendererBase() {
        super(MESSAGE_BUNDLE_NAME);
    }

    public void encodeSLCaption(FacesContext context, UIOrderingBaseComponent shuttle) throws IOException {
        this.encodeCaption(context, (UIComponent)shuttle, FACET_SOURCE_CAPTION, "rich-shuttle-source-caption", "sourceCaptionLabel");
    }

    public void encodeTLCaption(FacesContext context, UIComponent shuttle) throws IOException {
        this.encodeCaption(context, shuttle, FACET_TARGET_CAPTION, "rich-shuttle-target-caption", "targetCaptionLabel");
    }

    public void encodeSLHeader(FacesContext context, UIOrderingBaseComponent shuttle) throws IOException {
        this.encodeHeader(context, shuttle, "rich-table-header", "rich-shuttle-header-tab-cell", "sourceHeaderClass");
    }

    public void encodeTLHeader(FacesContext context, UIOrderingBaseComponent shuttle) throws IOException {
        this.encodeHeader(context, shuttle, "rich-table-header", "rich-shuttle-header-tab-cell", "sourceHeaderClass");
    }

    public boolean isHeaderExists(FacesContext context, UIOrderingBaseComponent component) {
        return this.isHeaderExists(context, component, "header");
    }

    protected String encodeRows(FacesContext context, UIOrderingBaseComponent shuttle, boolean source) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        context.setResponseWriter(writer.cloneWithWriter((Writer)stringWriter));
        this.encodeRows(context, (UIComponent)shuttle, new ListShuttleRendererTableHolder(shuttle, this.getConverter(context, shuttle, true), source));
        context.getResponseWriter().flush();
        context.setResponseWriter(writer);
        return stringWriter.getBuffer().toString();
    }

    public void encodeOneRow(FacesContext context, TableHolder holder) throws IOException {
        boolean source;
        UIListShuttle table = (UIListShuttle)holder.getTable();
        ListShuttleRendererTableHolder shuttleRendererTableHolder = (ListShuttleRendererTableHolder)holder;
        ListShuttleRowKey listShuttleRowKey = (ListShuttleRowKey)table.getRowKey();
        if (listShuttleRowKey != null && (source = shuttleRendererTableHolder.isSource()) == listShuttleRowKey.isFacadeSource()) {
            ResponseWriter writer = context.getResponseWriter();
            String clientId = table.getClientId(context);
            writer.startElement("tr", (UIComponent)table);
            writer.writeAttribute("id", (Object)clientId, null);
            StringBuffer rowClassName = new StringBuffer();
            StringBuffer cellClassName = new StringBuffer();
            if (source) {
                rowClassName.append("rich-shuttle-source-row");
                cellClassName.append("rich-shuttle-source-cell");
            } else {
                rowClassName.append("rich-shuttle-target-row");
                cellClassName.append("rich-shuttle-target-cell");
            }
            String rowClass = holder.getRowClass();
            if (rowClass != null) {
                rowClassName.append(' ');
                rowClassName.append(rowClass);
            }
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)table);
            OrderingComponentRendererBase.SelectionState selectionState = (OrderingComponentRendererBase.SelectionState)variables.getVariable(SELECTION_STATE_VAR_NAME);
            UIOrderingBaseComponent.ItemState itemState = this.getItemState(context, (UIComponent)table, variables);
            boolean active = itemState.isActive();
            boolean selected = itemState.isSelected();
            selectionState.addState(selected);
            if (selected) {
                if (source) {
                    rowClassName.append(" rich-shuttle-source-row-selected");
                    cellClassName.append(" rich-shuttle-source-cell-selected");
                } else {
                    rowClassName.append(" rich-shuttle-target-row-selected");
                    cellClassName.append(" rich-shuttle-target-cell-selected");
                }
            }
            writer.writeAttribute("class", (Object)rowClassName.toString(), null);
            int colCounter = 0;
            boolean columnRendered = false;
            Iterator iterator = table.columns();
            while (iterator.hasNext()) {
                UIComponent component = (UIComponent)iterator.next();
                if (component.isRendered()) {
                    String columnClass;
                    writer.startElement("td", (UIComponent)table);
                    Object width = component.getAttributes().get("width");
                    if (width != null) {
                        writer.writeAttribute("style", (Object)("width: " + HtmlUtil.qualifySize((String)width.toString())), null);
                    }
                    if ((columnClass = holder.getColumnClass(colCounter)) != null) {
                        writer.writeAttribute("class", (Object)cellClassName.toString().concat(" " + columnClass), null);
                    } else {
                        writer.writeAttribute("class", (Object)cellClassName.toString(), null);
                    }
                    writer.startElement("img", (UIComponent)table);
                    writer.writeAttribute("src", (Object)this.getResource("/org/richfaces/renderkit/html/images/spacer.gif").getUri(context, null), null);
                    writer.writeAttribute("style", (Object)"width:1px;height:1px;", null);
                    writer.writeAttribute("alt", (Object)" ", null);
                    writer.endElement("img");
                    this.renderChildren(context, component);
                    if (!columnRendered) {
                        writer.startElement("input", (UIComponent)table);
                        writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
                        writer.writeAttribute("name", (Object)table.getBaseClientId(context), null);
                        StringBuffer value = new StringBuffer();
                        if (selected) {
                            value.append('s');
                        }
                        if (active) {
                            value.append('a');
                        }
                        value.append(table.getRowKey());
                        value.append(':');
                        value.append(shuttleRendererTableHolder.getConverter().getAsString(context, (UIComponent)table, table.getRowData()));
                        writer.writeAttribute("value", (Object)value.toString(), null);
                        writer.writeAttribute("id", (Object)(clientId + "StateInput"), null);
                        writer.endElement("input");
                        columnRendered = true;
                    }
                    writer.endElement("td");
                }
                ++colCounter;
            }
            writer.endElement("tr");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeChildren(writer, context, component);
        }
    }

    public void encodeShuttleControlsFacets(FacesContext context, UIOrderingBaseComponent component, OrderingComponentRendererBase.SelectionState sourceSelectionState, OrderingComponentRendererBase.SelectionState targetSelectionState) throws IOException {
        String clientId = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        int divider = SHUTTLE_HELPERS.length / 2;
        for (int i = 0; i < SHUTTLE_HELPERS.length; ++i) {
            OrderingComponentRendererBase.SelectionState state = i < divider ? sourceSelectionState : targetSelectionState;
            boolean enabled = i <= 1 || i >= SHUTTLE_HELPERS.length - 2 ? state.isItemExist() : state.isSelected();
            if (i % 2 == 1) {
                boolean bl = enabled = !enabled;
            }
            if (!SHUTTLE_HELPERS[i].isRendered(context, component)) continue;
            this.encodeControlFacet(context, component, SHUTTLE_HELPERS[i], clientId, writer, enabled, "rich-list-shuttle-button", " rich-shuttle-control");
        }
    }

    public void encodeTLControlsFacets(FacesContext context, UIOrderingBaseComponent component, OrderingComponentRendererBase.SelectionState selectionState) throws IOException {
        String clientId = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        int divider = TL_HELPERS.length / 2;
        for (int i = 0; i < TL_HELPERS.length; ++i) {
            boolean enabled;
            boolean boundarySelection = i < divider ? selectionState.isFirstSelected() : selectionState.isLastSelected();
            boolean bl = enabled = selectionState.isSelected() && !boundarySelection;
            if (i % 2 == 1) {
                boolean bl2 = enabled = !enabled;
            }
            if (!TL_HELPERS[i].isRendered(context, component)) continue;
            this.encodeControlFacet(context, component, TL_HELPERS[i], clientId, writer, enabled, "rich-list-shuttle-button", " rich-shuttle-control");
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public void doDecode(FacesContext context, UIComponent component) {
        UIListShuttle listShuttle = (UIListShuttle)component;
        String clientId = listShuttle.getBaseClientId(context);
        ExternalContext externalContext = context.getExternalContext();
        Map requestParameterValuesMap = externalContext.getRequestParameterValuesMap();
        String[] strings = (String[])requestParameterValuesMap.get(clientId);
        if (strings != null && strings.length != 0) {
            HashSet<Object> sourceSelection = new HashSet<Object>();
            HashSet targetSelection = new HashSet();
            Object activeItem = null;
            LinkedHashMap<ListShuttleRowKey, Object> map = new LinkedHashMap<ListShuttleRowKey, Object>();
            boolean facadeSource = true;
            Converter converter = this.getConverter(context, listShuttle, false);
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                if (":".equals(string)) {
                    facadeSource = false;
                    continue;
                }
                int idx = string.indexOf(58);
                Object value = converter.getAsObject(context, (UIComponent)listShuttle, string.substring(idx + 1));
                String substring = string.substring(0, idx);
                idx = 0;
                boolean source = true;
                boolean selected = false;
                if (substring.charAt(idx) == 's') {
                    (facadeSource ? sourceSelection : targetSelection).add(value);
                    ++idx;
                }
                if (substring.charAt(idx) == 'a') {
                    activeItem = value;
                    ++idx;
                }
                if (substring.charAt(idx) == 't') {
                    source = false;
                    ++idx;
                }
                substring = substring.substring(idx);
                ListShuttleRowKey key = new ListShuttleRowKey((Object)new Integer(substring), source, facadeSource);
                map.put(key, value);
            }
            listShuttle.setSubmittedStrings(map, sourceSelection, targetSelection, activeItem);
        }
    }

    public String getCaptionDisplay(FacesContext context, UIComponent component) {
        UIListShuttle shuttle = (UIListShuttle)component;
        if (shuttle.getSourceCaptionLabel() != null && !"".equals(shuttle.getSourceCaptionLabel()) || shuttle.getTargetCaptionLabel() != null && !"".equals(shuttle.getTargetCaptionLabel()) || shuttle.getFacet(FACET_SOURCE_CAPTION) != null && shuttle.getFacet(FACET_SOURCE_CAPTION).isRendered() || shuttle.getFacet(FACET_TARGET_CAPTION) != null && shuttle.getFacet(FACET_TARGET_CAPTION).isRendered()) {
            return "";
        }
        return "display: none;";
    }

    private static class ListShuttleRendererTableHolder
    extends TableHolder {
        private boolean source;
        private Converter converter;

        public ListShuttleRendererTableHolder(UIDataAdaptor table, Converter converter, boolean source) {
            super(table);
            this.converter = converter;
            this.source = source;
        }

        public boolean isSource() {
            return this.source;
        }

        public Converter getConverter() {
            return this.converter;
        }
    }
}

