/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.InternalManagedConnectionPool;

public class ConnectionValidator {
    private static final Logger log = Logger.getLogger(ConnectionValidator.class);
    private final CopyOnWriteArrayList<InternalManagedConnectionPool> pools = new CopyOnWriteArrayList();
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private static final ConnectionValidator validator = new ConnectionValidator();

    private ConnectionValidator() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ConnectionValidatorRunnable runnable = new ConnectionValidatorRunnable();
                Thread removerThread = new Thread((Runnable)runnable, "ConnectionValidator");
                removerThread.setDaemon(true);
                removerThread.start();
                return null;
            }
        });
    }

    public static void registerPool(InternalManagedConnectionPool mcp, long interval) {
        validator.internalRegisterPool(mcp, interval);
    }

    public static void unRegisterPool(InternalManagedConnectionPool mcp) {
        validator.internalUnregisterPool(mcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegisterPool(InternalManagedConnectionPool mcp, long interval) {
        CopyOnWriteArrayList<InternalManagedConnectionPool> copyOnWriteArrayList = this.pools;
        synchronized (copyOnWriteArrayList) {
            this.pools.addIfAbsent(mcp);
            if (interval > 1L && interval / 2L < this.interval) {
                this.interval = interval / 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    this.next = maybeNext;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("internalRegisterPool: about to notify thread: old next: " + this.next + ", new next: " + maybeNext));
                    }
                    this.pools.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterPool(InternalManagedConnectionPool mcp) {
        CopyOnWriteArrayList<InternalManagedConnectionPool> copyOnWriteArrayList = this.pools;
        synchronized (copyOnWriteArrayList) {
            this.pools.remove(mcp);
            if (this.pools.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"internalUnregisterPool: setting interval to Long.MAX_VALUE");
                }
                this.interval = Long.MAX_VALUE;
            }
        }
    }

    private void setupContextClassLoader() {
        final ClassLoader cl = ConnectionValidator.class.getClassLoader();
        if (cl == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBackgroundThread() {
        CopyOnWriteArrayList<InternalManagedConnectionPool> copyOnWriteArrayList = ConnectionValidator.validator.pools;
        synchronized (copyOnWriteArrayList) {
            return;
        }
    }

    private class ConnectionValidatorRunnable
    implements Runnable {
        private ConnectionValidatorRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ConnectionValidator.this.setupContextClassLoader();
            CopyOnWriteArrayList copyOnWriteArrayList = ConnectionValidator.this.pools;
            synchronized (copyOnWriteArrayList) {
                while (true) {
                    try {
                        while (true) {
                            ConnectionValidator.this.pools.wait(ConnectionValidator.this.interval);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("run: ConnectionValidator notifying pools, interval: " + ConnectionValidator.this.interval));
                            }
                            for (InternalManagedConnectionPool mcp : ConnectionValidator.this.pools) {
                                mcp.validateConnections();
                            }
                            ConnectionValidator.this.next = System.currentTimeMillis() + ConnectionValidator.this.interval;
                            if (ConnectionValidator.this.next >= 0L) continue;
                            ConnectionValidator.this.next = Long.MAX_VALUE;
                        }
                    }
                    catch (InterruptedException e) {
                        log.info((Object)"run: ConnectionValidator has been interrupted, returning");
                        return;
                    }
                    catch (RuntimeException e) {
                        log.warn((Object)"run: ConnectionValidator ignored unexpected runtime exception", (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        log.warn((Object)"run: ConnectionValidator ignored unexpected error", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

