/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class BasicAuthValve
extends ValveBase {
    private static Logger log = Logger.getLogger(BasicAuthValve.class);
    private static boolean trace = log.isTraceEnabled();
    private boolean useExceptionAsMsg = false;
    private boolean clearAuthException = true;
    private String exceptionHeader = null;

    public boolean isUseExceptionAsMsg() {
        return this.useExceptionAsMsg;
    }

    public void setUseExceptionAsMsg(boolean useExceptionAsMsg) {
        this.useExceptionAsMsg = useExceptionAsMsg;
    }

    public String getExceptionHeader() {
        return this.exceptionHeader;
    }

    public void setExceptionHeader(String exceptionHeader) {
        this.exceptionHeader = exceptionHeader;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        Throwable t = SecurityAssociationActions.getAuthException();
        int status = response.getStatus();
        if (trace) {
            log.trace((Object)("Status: " + status + "SecurityAssociation.exception: "), t);
        }
        if (status >= 400 && t != null) {
            String msg = t.getMessage();
            if (this.useExceptionAsMsg && response.getCoyoteResponse() != null) {
                response.getCoyoteResponse().setMessage(msg);
            }
            if (this.exceptionHeader != null) {
                response.setHeader(this.exceptionHeader, msg);
            }
            if (this.clearAuthException) {
                try {
                    SecurityAssociationActions.clearAuthException();
                }
                catch (Throwable e) {
                    log.warn((Object)"Unable to clear auth exception ", e);
                }
            }
        }
    }
}

