/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import java.util.HashMap;
import java.util.Map;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheEntry;
import org.ajax4jsf.cache.CacheException;
import org.ajax4jsf.cache.CacheListener;
import org.ajax4jsf.cache.CacheLoader;
import org.ajax4jsf.cache.LRUMapFuture;
import org.ajax4jsf.util.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUMapCache
extends LRUMap<Object, Object>
implements Cache {
    private static final long serialVersionUID = 3236528957956574490L;
    private CacheLoader cacheLoader;
    private Map<Object, LRUMapFuture> futures = new HashMap<Object, LRUMapFuture>();

    public LRUMapCache(CacheLoader cacheLoader, int initialSize) {
        super(initialSize);
        this.cacheLoader = cacheLoader;
    }

    public LRUMapCache(CacheLoader cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void addListener(CacheListener listener) {
    }

    public void evict() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(Object key, Object context) throws CacheException {
        Map<Object, LRUMapFuture> map;
        Object object;
        LRUMapFuture activeFuture = null;
        LRUMapFuture future = null;
        Object object2 = this.futures;
        synchronized (object2) {
            future = this.futures.get(key);
            if (future == null) {
                activeFuture = new LRUMapFuture();
                this.futures.put(key, activeFuture);
            }
        }
        if (future != null) {
            object2 = future;
            synchronized (object2) {
                future.wait();
                return future.getResult();
            }
        }
        try {
            if (!this.containsKey(key)) {
                this.load(key, context);
            }
            Object result = this.peek(key);
            activeFuture.setResult(result);
            object = result;
            map = this.futures;
        }
        catch (Throwable throwable) {
            try {
                Map<Object, LRUMapFuture> map2 = this.futures;
                synchronized (map2) {
                    this.futures.remove(key);
                    LRUMapFuture lRUMapFuture = activeFuture;
                    synchronized (lRUMapFuture) {
                        activeFuture.notifyAll();
                    }
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new CacheException(e.getMessage(), (Throwable)e);
            }
        }
        synchronized (map) {
            this.futures.remove(key);
            LRUMapFuture lRUMapFuture = activeFuture;
            synchronized (lRUMapFuture) {
                activeFuture.notifyAll();
            }
        }
        return object;
    }

    public CacheEntry getCacheEntry(Object key) {
        return null;
    }

    public synchronized void load(Object key, Object context) throws CacheException {
        this.put(key, this.cacheLoader.load(key, context));
    }

    public synchronized Object peek(Object key) {
        return this.get(key);
    }

    public void removeListener(CacheListener listener) {
    }
}

