/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.uuidgen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.juddi.uuidgen.UUIDGen;

public final class Win32UUIDGen
implements UUIDGen {
    public String uuidgen() {
        String[] uuids = this.uuidgen(1);
        return uuids[0];
    }

    public String[] uuidgen(int nmbr) {
        String[] uuids = new String[nmbr];
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec("uuidgen -n" + nmbr);
            BufferedReader x = new BufferedReader(new InputStreamReader(p.getInputStream()));
            for (int i = 0; i < nmbr; ++i) {
                uuids[i] = x.readLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
        return uuids;
    }

    public static void main(String[] args) {
        Win32UUIDGen uuidgen = new Win32UUIDGen();
        long start = System.currentTimeMillis();
        for (int i = 1; i <= 250; ++i) {
            System.out.println(i + ":  " + uuidgen.uuidgen());
        }
        long end = System.currentTimeMillis();
        System.out.println("Generation (and display) of 250 UUID's took " + (end - start) + " milliseconds.");
        start = System.currentTimeMillis();
        String[] ids = uuidgen.uuidgen(250);
        for (int i = 1; i < 250; ++i) {
            System.out.println(i + ":  " + ids[i]);
        }
        end = System.currentTimeMillis();
        System.out.println("Generation (and display) of 250 UUID's took " + (end - start) + " milliseconds.");
    }
}

