/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.access;

import java.util.HashSet;
import javax.jcr.LoginException;
import org.exoplatform.services.jcr.access.AuthenticationPolicy;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;

public abstract class BaseAuthenticator
implements AuthenticationPolicy {
    protected static Log log = ExoLogger.getLogger((String)"jcr.BaseAuthenticator");
    protected RepositoryEntry config;
    protected IdentityRegistry identityRegistry;

    public BaseAuthenticator(RepositoryEntry config, IdentityRegistry identityRegistry) {
        this.config = config;
        this.identityRegistry = identityRegistry;
    }

    public ConversationState authenticate() throws LoginException {
        ConversationState state = ConversationState.getCurrent();
        if (state == null) {
            log.debug((Object)"No current identity found, ANONYMOUS one will be used");
            return new ConversationState(new Identity(SystemIdentity.ANONIM, new HashSet()));
        }
        ConversationState.setCurrent((ConversationState)state);
        return state;
    }
}

