/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.HashMap;
import org.exoplatform.container.client.ClientInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionContainer
extends HashMap<Object, Object> {
    private static ThreadLocal threadLocal_ = new ThreadLocal();
    public static final int INIT_STATUS = 0;
    public static final int START_STATUS = 1;
    public static final int STOP_STATUS = 2;
    public static final int DESTROY_STATUS = 3;
    private String owner_;
    private String portalName_;
    private ClientInfo clientInfo_;
    private long startTime_ = -1L;
    private String sessionId_;
    private String uniqueId_;
    private int status_;
    private long lastAccessTime_;

    public SessionContainer(String id, String owner) {
        this.sessionId_ = id;
        this.owner_ = owner;
    }

    public String getSessionId() {
        return this.sessionId_;
    }

    public String getUniqueId() {
        return this.uniqueId_;
    }

    public void setUniqueId(String s) {
        this.uniqueId_ = s;
    }

    public String getOwner() {
        return this.owner_;
    }

    public String getRemoteUser() {
        return this.clientInfo_.getRemoteUser();
    }

    public String getPortalName() {
        return this.portalName_;
    }

    public void setPortalName(String name) {
        this.portalName_ = name;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo_;
    }

    public void setClientInfo(ClientInfo ci) {
        this.clientInfo_ = ci;
    }

    public int getStatus() {
        return this.status_;
    }

    public void setStatus(int status) {
        this.status_ = status;
    }

    public long getCreationTime() {
        return this.startTime_;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime_;
    }

    public void setLastAccessTime(long time) {
        if (this.startTime_ < 0L) {
            this.startTime_ = time;
        }
        this.lastAccessTime_ = time;
    }

    public long getLiveTime() {
        return System.currentTimeMillis() - this.startTime_;
    }

    public long getLiveTimeInMinute() {
        return (System.currentTimeMillis() - this.startTime_) / 60000L;
    }

    public long getLiveTimeInSecond() {
        return (System.currentTimeMillis() - this.startTime_) / 1000L;
    }

    public static Object getComponent(Class key) {
        SessionContainer scontainer = (SessionContainer)threadLocal_.get();
        return scontainer.get(key);
    }

    public final void registerComponentInstance(Object key, Object obj) {
        this.put(key, obj);
    }

    public final Object getComponentInstance(Object key) {
        return this.get(key);
    }

    public final Object getComponentInstanceOfType(Class key) {
        return this.get(key);
    }

    public static SessionContainer getInstance() {
        return (SessionContainer)threadLocal_.get();
    }

    public static void setInstance(SessionContainer scontainer) {
        threadLocal_.set(scontainer);
    }
}

