/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.ext.replication.ReplicationChannelManager;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jgroups.Address;

public class WorkspaceDataTransmitter
implements ItemsPersistenceListener {
    private static Log log = ExoLogger.getLogger("ext.WorksapeDataTransmitter");
    private String systemId;
    private ReplicationChannelManager channelManager;
    private FileCleaner fileCleaner;
    private RecoveryManager recoveryManager;
    private String ownName;

    public WorkspaceDataTransmitter(CacheableWorkspaceDataManager dataManager) throws RepositoryConfigurationException {
        dataManager.addItemPersistenceListener((ItemsPersistenceListener)this);
        this.fileCleaner = new FileCleaner(30030L);
    }

    public void init(ReplicationChannelManager channelManager, String systemId, String ownName, RecoveryManager recoveryManager) {
        this.systemId = systemId;
        this.channelManager = channelManager;
        this.ownName = ownName;
        this.recoveryManager = recoveryManager;
        log.info("Own name  : " + ownName);
        log.info("System ID : " + systemId);
    }

    public void onSaveItems(ItemStateChangesLog isChangesLog) {
        TransactionChangesLog changesLog = (TransactionChangesLog)isChangesLog;
        if (changesLog.getSystemId() == null && !this.isSessionNull(changesLog)) {
            changesLog.setSystemId(this.systemId);
            try {
                if (log.isDebugEnabled()) {
                    ChangesLogIterator logIterator = changesLog.getLogIterator();
                    while (logIterator.hasNextLog()) {
                        PlainChangesLog pcl = logIterator.nextLog();
                        log.info(pcl.dump());
                    }
                }
                String identifier = this.sendAsBinaryFile((ItemStateChangesLog)changesLog);
                if (log.isDebugEnabled()) {
                    log.info("After send message: the owner systemId --> " + changesLog.getSystemId());
                    log.info("After send message: --> " + this.systemId);
                }
            }
            catch (Exception e) {
                log.error("Can not sent ChangesLog ...", e);
            }
        }
    }

    private String sendAsBinaryFile(ItemStateChangesLog isChangesLog) throws Exception {
        String identifier = IdGenerator.generate();
        String fName = this.recoveryManager.save(isChangesLog, identifier);
        this.channelManager.sendBinaryFile(new File(fName).getCanonicalPath(), this.ownName, identifier, this.systemId, 32);
        return identifier;
    }

    public void suspect(Address suspectedMbr) {
    }

    public void block() {
    }

    private boolean isSessionNull(TransactionChangesLog changesLog) {
        boolean isSessionNull = false;
        ChangesLogIterator logIterator = changesLog.getLogIterator();
        while (logIterator.hasNextLog()) {
            if (logIterator.nextLog().getSessionId() != null) continue;
            isSessionNull = true;
            break;
        }
        return isSessionNull;
    }

    public ReplicationChannelManager getChannelManager() {
        return this.channelManager;
    }

    public boolean isTXAware() {
        return true;
    }
}

