/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.impl;

import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceIdentityProvider
extends IdentityProvider<Space> {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceIdentityProvider.class);
    public static final String NAME = "space";
    private SpaceService spaceService;

    public SpaceIdentityProvider(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    public Space findByRemoteId(String spaceId) {
        Space space;
        try {
            space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                List<Space> spaces;
                String name = spaceId;
                if (spaceId.contains(":")) {
                    name = spaceId.split(":")[1];
                }
                if ((spaces = this.spaceService.getSpacesByName(name, false)) != null && spaces.size() > 0) {
                    return spaces.get(0);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not find space " + spaceId), (Throwable)e);
            return null;
        }
        return space;
    }

    public String getName() {
        return NAME;
    }

    public Identity populateIdentity(Space space) {
        Identity identity = new Identity(NAME, space.getId());
        Profile profile = identity.getProfile();
        profile.setProperty("firstName", (Object)space.getName());
        profile.setProperty("username", (Object)space.getGroupId());
        profile.setProperty("avatarUrl", (Object)space.getImageSource());
        profile.setProperty("Url", (Object)space.getImageSource());
        return identity;
    }
}

