/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.token.attribute;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.chars.ValueVerifier;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.token.attribute.Attribute;
import org.exoplatform.services.token.attribute.AttributeParser;
import org.exoplatform.services.token.attribute.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeUtil {
    public synchronized List<String> getAttributes(HTMLNode node, Map<String, String> map) {
        return this.getAttributes(node, null, map, null);
    }

    public synchronized List<String> getAttributes(HTMLNode node, Map<String, String> map, ValueVerifier verifier) {
        return this.getAttributes(node, null, map, verifier);
    }

    public synchronized String getAttribute(HTMLNode node, Map<String, String> map, ValueVerifier verifier) {
        Attribute attr = this.getAttribute(node, map);
        if (attr != null && (verifier == null || verifier.verify(attr.getValue()))) {
            return attr.getValue();
        }
        List<HTMLNode> children = node.getChildrenNode();
        for (HTMLNode ele : children) {
            String link = this.getAttribute(ele, map, verifier);
            if (link == null) continue;
            return link;
        }
        return null;
    }

    public synchronized List<String> getAttributes(HTMLNode node, List<String> list, Map<String, String> map, ValueVerifier verifier) {
        Attribute attr;
        if (list == null) {
            list = new ArrayList<String>();
        }
        if ((attr = this.getAttribute(node, map)) != null && (verifier == null || verifier.verify(attr.getValue()))) {
            list.add(attr.getValue());
        }
        List<HTMLNode> children = node.getChildrenNode();
        for (HTMLNode ele : children) {
            this.getAttributes(ele, list, map, verifier);
        }
        return list;
    }

    public synchronized Attribute getAttribute(HTMLNode node, Map<String, String> map) {
        Set<String> keys = map.keySet();
        for (String key : keys) {
            Attributes attrs;
            int idx;
            if (!node.isNode(key) || (idx = (attrs = AttributeParser.getAttributes(node)).indexOf(map.get(key))) <= -1) continue;
            return (Attribute)attrs.get(idx);
        }
        return null;
    }
}

