/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ejb;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.ApplicationException;
import javax.ejb.Remove;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Interceptor(stateless=true, type=InterceptorType.CLIENT)
public class RemoveInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -6693606158918954699L;
    private static final LogProvider log = Logging.getLogProvider(RemoveInterceptor.class);

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Object result;
        Method removeMethod = this.getComponent().getRemoveMethod(invocation.getMethod().getName());
        try {
            result = invocation.proceed();
        }
        catch (Exception exception) {
            this.removeIfNecessary(removeMethod, exception);
            throw exception;
        }
        this.removeIfNecessary(removeMethod);
        return result;
    }

    private void removeIfNecessary(Method removeMethod, Exception exception) {
        if (exception instanceof RuntimeException || exception instanceof RemoteException) {
            if (!exception.getClass().isAnnotationPresent(ApplicationException.class)) {
                this.remove();
            }
        } else if (removeMethod != null && !removeMethod.getAnnotation(Remove.class).retainIfException()) {
            this.remove();
        }
    }

    private void removeIfNecessary(Method removeMethod) {
        if (removeMethod != null) {
            this.remove();
        }
    }

    private void remove() {
        this.getComponent().getScope().getContext().remove(this.getComponent().getName());
        if (log.isDebugEnabled()) {
            log.debug("Stateful component was removed: " + this.getComponent().getName());
        }
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().getType() == ComponentType.STATEFUL_SESSION_BEAN;
    }
}

