/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.SortedMap;
import org.gatein.common.xml.NullEntityResolver;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.registry.AbstractConsumerRegistry;
import org.gatein.wsrp.consumer.registry.xml.XMLWSRPConsumerFactory;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConsumerRegistry
extends AbstractConsumerRegistry {
    private static final Logger log = LoggerFactory.getLogger(XMLConsumerRegistry.class);
    private static final String defaultWSRPLocation = "conf/wsrp-consumers-config.xml";
    private EntityResolver entityResolver;

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public void reloadConsumers() {
        URL defaultWSRPURL = Thread.currentThread().getContextClassLoader().getResource(defaultWSRPLocation);
        if (defaultWSRPURL != null) {
            InputStream inputStream;
            try {
                inputStream = defaultWSRPURL.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't open default XML WSRP Consumer configuration file", e);
            }
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            XMLWSRPConsumerFactory factory = new XMLWSRPConsumerFactory(this);
            if (this.entityResolver == null) {
                log.debug("Could not obtain entity resolver for XMLConsumerRegistry");
                this.entityResolver = new NullEntityResolver();
            }
            try {
                unmarshaller.setEntityResolver(this.entityResolver);
                this.initConsumers((SortedMap)unmarshaller.unmarshal(inputStream, (ObjectModelFactory)factory, null));
            }
            catch (JBossXBException e) {
                throw new RuntimeException("Couldn't set unmarshall WSRP Consumers configuration", e);
            }
            for (WSRPConsumer consumer : this.getConsumers()) {
                ProducerInfo producerInfo = consumer.getProducerInfo();
                try {
                    this.activateConsumer(consumer);
                }
                catch (Exception e) {
                    producerInfo.setActive(false);
                    this.updateProducerInfo(producerInfo);
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        for (WSRPConsumer consumer : this.getConsumers()) {
            consumer.stop();
        }
    }

    @Override
    protected void save(ProducerInfo info, String messageOnError) {
    }

    @Override
    protected void delete(ProducerInfo info) {
    }

    @Override
    protected String update(ProducerInfo producerInfo) {
        return null;
    }

    @Override
    protected Iterator<ProducerInfo> getProducerInfosFromStorage() {
        return new AbstractConsumerRegistry.ProducerInfoIterator(this, this.getConsumers().iterator());
    }
}

