/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTypeDefinitionImpl {
    private static final Log LOG = ExoLogger.getLogger(NodeTypeDefinitionImpl.class);
    protected NodeTypeData nodeTypeData;
    protected final NodeTypeDataManager nodeTypeDataManager;
    protected final LocationFactory locationFactory;
    protected final ExtendedNodeTypeManager nodeTypeManager;
    protected final ValueFactory valueFactory;

    public NodeTypeDefinitionImpl(NodeTypeData nodeTypeData, NodeTypeDataManager nodeTypeDataManager, ExtendedNodeTypeManager nodeTypeManager, LocationFactory locationFactory, ValueFactory valueFactory) {
        this.nodeTypeData = nodeTypeData;
        this.nodeTypeDataManager = nodeTypeDataManager;
        this.nodeTypeManager = nodeTypeManager;
        this.locationFactory = locationFactory;
        this.valueFactory = valueFactory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeTypeDefinitionImpl)) {
            return false;
        }
        NodeTypeDefinitionImpl other = (NodeTypeDefinitionImpl)obj;
        return !(this.nodeTypeData == null ? other.nodeTypeData != null : !this.nodeTypeData.equals(other.nodeTypeData));
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        NodeDefinition[] result = new NodeDefinition[this.nodeTypeData.getDeclaredChildNodeDefinitions().length];
        for (int i = 0; i < this.nodeTypeData.getDeclaredChildNodeDefinitions().length; ++i) {
            result[i] = new NodeDefinitionImpl(this.nodeTypeData.getDeclaredChildNodeDefinitions()[i], this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory);
        }
        return result;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        PropertyDefinition[] result = new PropertyDefinition[this.nodeTypeData.getDeclaredPropertyDefinitions().length];
        for (int i = 0; i < this.nodeTypeData.getDeclaredPropertyDefinitions().length; ++i) {
            result[i] = new PropertyDefinitionImpl(this.nodeTypeData.getDeclaredPropertyDefinitions()[i], this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory);
        }
        return result;
    }

    public String[] getDeclaredSupertypeNames() {
        String[] result = new String[this.nodeTypeData.getDeclaredSupertypeNames().length];
        try {
            for (int i = 0; i < this.nodeTypeData.getDeclaredSupertypeNames().length; ++i) {
                result[i] = this.locationFactory.createJCRName(this.nodeTypeData.getDeclaredSupertypeNames()[i]).getAsString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public String getName() {
        String result = "";
        try {
            result = this.locationFactory.createJCRName(this.nodeTypeData.getName()).getAsString();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public String getPrimaryItemName() {
        String result = "";
        try {
            result = this.locationFactory.createJCRName(this.nodeTypeData.getPrimaryItemName()).getAsString();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeTypeData == null ? 0 : this.nodeTypeData.hashCode());
        return result;
    }

    public boolean hasOrderableChildNodes() {
        return this.nodeTypeData.hasOrderableChildNodes();
    }

    public boolean isMixin() {
        return this.nodeTypeData.isMixin();
    }
}

