/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.modify;

import java.util.List;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.ModificationType;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.plugins.structure.modify.ModificationTypeMatcher;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;

public abstract class AbstractModificationTypeMatcher
implements ModificationTypeMatcher {
    protected Logger log = Logger.getLogger(this.getClass());
    private boolean checkChildren;
    private boolean topLevelOnly;
    private boolean childrenOnly;
    private ModificationType modificationType;

    public boolean determineModification(VirtualFile root, StructureMetaData structureMetaData) {
        List contexts;
        boolean result;
        ContextInfo contextInfo = structureMetaData.getContext("");
        if (!this.childrenOnly && (result = this.isModificationDetermined(root, contextInfo))) {
            contextInfo.setModificationType(this.modificationType);
            return true;
        }
        if (this.checkChildren && (contexts = structureMetaData.getContexts()) != null && !contexts.isEmpty()) {
            for (ContextInfo child : contexts) {
                String path = child.getPath();
                if ("".equals(path)) continue;
                try {
                    VirtualFile file = root.getChild(path);
                    if (file == null || !this.isModificationDetermined(file, child)) continue;
                    contextInfo.setModificationType(this.modificationType);
                    return true;
                }
                catch (Exception e) {
                    this.log.debug((Object)("Exception checking child context (" + child + ") for modification, cause: " + e));
                }
            }
        }
        return false;
    }

    public boolean determineModification(VirtualFile root, ContextInfo contextInfo) {
        boolean result = false;
        if (!this.topLevelOnly && (result = this.isModificationDetermined(root, contextInfo))) {
            contextInfo.setModificationType(this.modificationType);
        }
        return result;
    }

    protected abstract boolean isModificationDetermined(VirtualFile var1, ContextInfo var2);

    public void setCheckChildren(boolean checkChildren) {
        this.checkChildren = checkChildren;
    }

    public void setTopLevelOnly(boolean topLevelOnly) {
        this.topLevelOnly = topLevelOnly;
    }

    public void setChildrenOnly(boolean childrenOnly) {
        this.childrenOnly = childrenOnly;
    }

    public void setModificationType(ModificationType modificationType) {
        this.modificationType = modificationType;
    }
}

