/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
import org.jboss.classloader.spi.ClassLoaderDomainMBean;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderDomain
extends BaseClassLoaderDomain
implements Loader,
ClassLoaderDomainMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(ClassLoaderDomain.class);
    private String name;
    private ParentPolicy parentPolicy = ParentPolicy.BEFORE;
    private Loader parent;
    private MBeanServer mbeanServer;
    private ObjectName objectName;
    private boolean useLoadClassForParent = false;

    public ClassLoaderDomain(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.fixUpParent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public ParentPolicy getParentPolicy() {
        return this.parentPolicy;
    }

    public void setParentPolicy(ParentPolicy parentPolicy) {
        if (parentPolicy == null) {
            throw new IllegalArgumentException("Null parent policy");
        }
        this.parentPolicy = parentPolicy;
    }

    @Override
    public String getParentPolicyName() {
        return this.parentPolicy.toString();
    }

    public Loader getParent() {
        return this.parent;
    }

    public void setParent(Loader parent) {
        this.parent = parent;
        this.fixUpParent();
    }

    @Override
    public boolean isUseLoadClassForParent() {
        return this.useLoadClassForParent;
    }

    public void setUseLoadClassForParent(boolean useLoadClassForParent) {
        this.useLoadClassForParent = useLoadClassForParent;
    }

    @Override
    public ObjectName getParentDomain() {
        if (this.parent == null || !(this.parent instanceof ClassLoaderDomain)) {
            return null;
        }
        ClassLoaderDomain parentDomain = (ClassLoaderDomain)this.parent;
        return parentDomain.getObjectName();
    }

    @Override
    public String getParentDomainName() {
        if (this.parent == null || !(this.parent instanceof ClassLoaderDomain)) {
            return null;
        }
        ClassLoaderDomain parentDomain = (ClassLoaderDomain)this.parent;
        return parentDomain.getName();
    }

    @Override
    public ObjectName getSystem() {
        ClassLoaderSystem system = (ClassLoaderSystem)this.getClassLoaderSystem();
        if (system == null) {
            return null;
        }
        return system.getObjectName();
    }

    @Override
    public List<ObjectName> listClassLoaders() {
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (ClassLoader cl : super.getAllClassLoaders()) {
            if (!(cl instanceof RealClassLoader)) continue;
            result.add(((RealClassLoader)cl).getObjectName());
        }
        return result;
    }

    @Override
    public Map<String, List<ObjectName>> listExportingClassLoaders() {
        HashMap<String, List<ObjectName>> result = new HashMap<String, List<ObjectName>>();
        for (Map.Entry<String, List<ClassLoader>> entry : this.getClassLoadersByPackage().entrySet()) {
            ArrayList<ObjectName> names = new ArrayList<ObjectName>();
            for (ClassLoader cl : entry.getValue()) {
                if (!(cl instanceof RealClassLoader)) continue;
                names.add(((RealClassLoader)cl).getObjectName());
            }
            result.put(entry.getKey(), names);
        }
        return result;
    }

    @Override
    public List<ObjectName> listExportingClassLoaders(String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Null package name");
        }
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (ClassLoader cl : this.getClassLoaders(packageName)) {
            if (!(cl instanceof RealClassLoader)) continue;
            result.add(((RealClassLoader)cl).getObjectName());
        }
        return result;
    }

    @Override
    public ObjectName findClassLoaderForClass(String name) throws ClassNotFoundException {
        final Class<?> clazz = this.loadClass(null, name, true);
        if (clazz == null) {
            return null;
        }
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
        if (cl != null && cl instanceof RealClassLoader) {
            return ((RealClassLoader)cl).getObjectName();
        }
        return null;
    }

    @Override
    public Set<URL> loadResources(String name) throws IOException {
        HashSet<URL> result = new HashSet<URL>();
        this.getResources(name, result);
        return result;
    }

    @Override
    protected void toLongString(StringBuilder builder) {
        builder.append("name=").append(this.getName());
        builder.append(" parentPolicy=").append(this.getParentPolicy());
        builder.append(" parent=");
        Loader parent = this.getParent();
        if (parent != null) {
            builder.append(parent);
        } else {
            builder.append(this.getParentClassLoader());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{").append(this.name).append('}');
        return builder.toString();
    }

    @Override
    protected Class<?> loadClassBefore(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesClassName(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.loadClassFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected Class<?> loadClassAfter(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesClassName(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.loadClassFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected Class<?> loadClassFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not loading from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " load class from parent " + name + " parent=" + this.parent));
        }
        return parentLoader.loadClass(name);
    }

    @Override
    protected Loader findBeforeLoader(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.findLoaderFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected Loader findAfterLoader(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.findLoaderFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected Loader findLoaderFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not loading from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " load from parent " + name + " parent=" + this.parent));
        }
        if (parentLoader instanceof ClassLoaderDomain) {
            ClassLoaderDomain parentDomain = (ClassLoaderDomain)parentLoader;
            return parentDomain.findLoader(name);
        }
        if (parentLoader.getResource(name) != null) {
            return parentLoader;
        }
        return null;
    }

    @Override
    protected URL beforeGetResource(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.getResourceFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected URL afterGetResource(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.getResourceFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected URL getResourceFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting resource from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " get resource from parent " + name + " parent=" + parentLoader));
        }
        URL result = parentLoader.getResource(name);
        if (trace) {
            if (result != null) {
                log.trace((Object)(this + " got resource from parent " + name + " parent=" + parentLoader + " " + result));
            } else {
                log.trace((Object)(this + " resource not found in parent " + name + " parent=" + parentLoader));
            }
        }
        return result;
    }

    @Override
    protected void beforeGetResources(String name, Set<URL> urls) throws IOException {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            this.getResourcesFromParent(name, urls);
        } else if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
    }

    @Override
    protected void afterGetResources(String name, Set<URL> urls) throws IOException {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            this.getResourcesFromParent(name, urls);
        } else if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
    }

    protected void getResourcesFromParent(String name, Set<URL> urls) throws IOException {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting resources from non-existant parent"));
            }
            return;
        }
        if (trace) {
            log.trace((Object)(this + " get resources from parent " + name + " parent=" + parentLoader));
        }
        parentLoader.getResources(name, urls);
    }

    @Override
    protected Package beforeGetPackage(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesPackageName(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.getPackageFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected Package afterGetPackage(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesPackageName(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.getPackageFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected Package getPackageFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting package from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " get package from parent " + name + " parent=" + parentLoader));
        }
        Package result = parentLoader.getPackage(name);
        if (trace) {
            if (result != null) {
                log.trace((Object)(this + " got package from parent " + name + " parent=" + parentLoader + " " + result));
            } else {
                log.trace((Object)(this + " package not found in parent " + name + " parent=" + parentLoader));
            }
        }
        return result;
    }

    @Override
    protected void beforeGetPackages(Set<Package> packages) {
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        this.getPackagesFromParent(packages, filter);
    }

    @Override
    protected void afterGetPackages(Set<Package> packages) {
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        this.getPackagesFromParent(packages, filter);
    }

    protected void getPackagesFromParent(Set<Package> packages, ClassFilter filter) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting packages from non-existant parent"));
            }
            return;
        }
        if (trace) {
            log.trace((Object)(this + " get packages from parent=" + parentLoader + " filter=" + filter));
        }
        HashSet<Package> parentPackages = new HashSet<Package>();
        parentLoader.getPackages(parentPackages);
        for (Package parentPackage : parentPackages) {
            if (filter.matchesPackageName(parentPackage.getName())) {
                if (trace) {
                    log.trace((Object)(this + " parentPackage=" + parentPackage + " matches filter=" + filter));
                }
                packages.add(parentPackage);
                continue;
            }
            if (!trace) continue;
            log.trace((Object)(this + " parentPackage=" + parentPackage + " does NOT match filter=" + filter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixUpParent() {
        try {
            ClassLoader classLoader;
            if (this.parent == null && (classLoader = this.getParentClassLoader()) != null) {
                this.parent = AccessController.doPrivileged(new PrivilegedAction<Loader>(){

                    @Override
                    public Loader run() {
                        return new ClassLoaderToLoaderAdapter(classLoader);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            this.setUseLoadClassForParent(!(this.parent instanceof ClassLoaderDomain));
            throw throwable;
        }
        this.setUseLoadClassForParent(!(this.parent instanceof ClassLoaderDomain));
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        this.objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            for (ClassLoader cl : this.getAllClassLoaders()) {
                this.registerClassLoaderMBean(cl);
            }
        } else {
            this.postDeregister();
        }
    }

    @Override
    public void preDeregister() throws Exception {
        for (ClassLoader cl : this.getAllClassLoaders()) {
            this.unregisterClassLoaderMBean(cl);
        }
    }

    @Override
    public void postDeregister() {
        this.mbeanServer = null;
        this.objectName = null;
    }

    @Override
    protected void afterRegisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
        this.registerClassLoaderMBean(classLoader);
    }

    @Override
    protected void beforeUnregisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
        this.unregisterClassLoaderMBean(classLoader);
    }

    protected void registerClassLoaderMBean(ClassLoader cl) {
        if (this.mbeanServer == null) {
            return;
        }
        if (cl instanceof RealClassLoader) {
            ObjectName name = ((RealClassLoader)cl).getObjectName();
            try {
                this.mbeanServer.registerMBean(cl, name);
            }
            catch (Exception e) {
                log.warn((Object)("Error registering classloader: " + cl), (Throwable)e);
            }
        }
    }

    protected void unregisterClassLoaderMBean(ClassLoader cl) {
        if (this.mbeanServer == null) {
            return;
        }
        if (cl instanceof RealClassLoader) {
            ObjectName name = ((RealClassLoader)cl).getObjectName();
            try {
                this.mbeanServer.unregisterMBean(name);
            }
            catch (Exception e) {
                log.warn((Object)("Error unregistering classloader: " + cl), (Throwable)e);
            }
        }
    }
}

