/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.lob.BlobImpl;
import org.hibernate.type.AbstractLobType;
import org.hibernate.util.ArrayHelper;

public class ByteArrayBlobType
extends AbstractLobType {
    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{2004};
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode, SessionFactoryImplementor factory) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x instanceof Byte[]) {
            Object[] o1 = (Object[])x;
            Object[] o2 = (Object[])y;
            return ArrayHelper.isEquals((Object[])o1, (Object[])o2);
        }
        byte[] c1 = (byte[])x;
        byte[] c2 = (byte[])y;
        return ArrayHelper.isEquals((byte[])c1, (byte[])c2);
    }

    public int getHashCode(Object x, EntityMode entityMode, SessionFactoryImplementor factory) {
        if (x instanceof Character[]) {
            Object[] o = (Object[])x;
            return ArrayHelper.hash((Object[])o);
        }
        byte[] c = (byte[])x;
        return ArrayHelper.hash((byte[])c);
    }

    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte[]) {
            Byte[] array = (Byte[])value;
            int length = array.length;
            Byte[] copy = new Byte[length];
            for (int index = 0; index < length; ++index) {
                copy[index] = (byte)array[index];
            }
            return copy;
        }
        byte[] array = (byte[])value;
        int length = array.length;
        byte[] copy = new byte[length];
        System.arraycopy(array, 0, copy, 0, length);
        return copy;
    }

    public Class getReturnedClass() {
        return Byte[].class;
    }

    protected Object get(ResultSet rs, String name) throws SQLException {
        Blob blob = rs.getBlob(name);
        if (rs.wasNull()) {
            return null;
        }
        int length = (int)blob.length();
        byte[] primaryResult = blob.getBytes(1L, length);
        return this.wrap(primaryResult);
    }

    protected void set(PreparedStatement st, Object value, int index, SessionImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, this.sqlTypes(null)[0]);
        } else {
            byte[] toSet = this.unWrap(value);
            boolean useInputStream = session.getFactory().getDialect().useInputStreamToInsertBlob();
            if (useInputStream) {
                st.setBinaryStream(index, (InputStream)new ByteArrayInputStream(toSet), toSet.length);
            } else {
                st.setBlob(index, (Blob)new BlobImpl(toSet));
            }
        }
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        node.setText(this.toString(value));
    }

    public String toString(Object val) {
        byte[] bytes = this.unWrap(val);
        StringBuilder buf = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            String hexStr = Integer.toHexString(bytes[i] - -128);
            if (hexStr.length() == 1) {
                buf.append('0');
            }
            buf.append(hexStr);
        }
        return buf.toString();
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        return value == null ? "null" : this.toString(value);
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        String xmlText = xml.getText();
        return xmlText == null || xmlText.length() == 0 ? null : this.fromString(xmlText);
    }

    private Object fromString(String xmlText) {
        if (xmlText == null) {
            return null;
        }
        if (xmlText.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid xml representation of a binary content.");
        }
        byte[] bytes = new byte[xmlText.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            String hexStr = xmlText.substring(i * 2, (i + 1) * 2);
            bytes[i] = (byte)(Integer.parseInt(hexStr, 16) + -128);
        }
        return this.wrap(bytes);
    }

    protected Object wrap(byte[] bytes) {
        return this.wrapPrimitive(bytes);
    }

    protected byte[] unWrap(Object bytes) {
        return this.unwrapNonPrimitive((Byte[])bytes);
    }

    private byte[] unwrapNonPrimitive(Byte[] bytes) {
        int length = bytes.length;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = bytes[i];
        }
        return result;
    }

    private Byte[] wrapPrimitive(byte[] bytes) {
        int length = bytes.length;
        Byte[] result = new Byte[length];
        for (int index = 0; index < length; ++index) {
            result[index] = bytes[index];
        }
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        if (this.isEqual(original, target, session.getEntityMode())) {
            return original;
        }
        return this.deepCopy(original, session.getEntityMode(), session.getFactory());
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }
}

