/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class VersionHistoryRemover {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.VersionHistoryRemover");
    private final String vhID;
    private final ItemDataConsumer dataManager;
    private final NodeTypeDataManager ntManager;
    private final RepositoryImpl repository;
    private final String currentWorkspaceName;
    private final QPath containingHistory;
    private final QPath ancestorToSave;
    private final PlainChangesLogImpl transientChangesLog;
    private final AccessManager accessManager;
    private final ConversationState userState;

    public VersionHistoryRemover(String vhID, ItemDataConsumer dataManager, NodeTypeDataManager ntManager, RepositoryImpl repository, String currentWorkspaceName, QPath containingHistory, QPath ancestorToSave, PlainChangesLogImpl transientChangesLog, AccessManager accessManager, ConversationState userState) {
        this.vhID = vhID;
        this.dataManager = dataManager;
        this.ntManager = ntManager;
        this.repository = repository;
        this.currentWorkspaceName = currentWorkspaceName;
        this.containingHistory = containingHistory;
        this.ancestorToSave = ancestorToSave;
        this.transientChangesLog = transientChangesLog;
        this.accessManager = accessManager;
        this.userState = userState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() throws RepositoryException {
        NodeData vhnode = (NodeData)this.dataManager.getItemData(this.vhID);
        if (vhnode == null) {
            ItemState vhState = null;
            List<ItemState> allStates = this.transientChangesLog.getAllStates();
            for (int i = allStates.size() - 1; i >= 0; --i) {
                ItemState state = allStates.get(i);
                if (!state.getData().getIdentifier().equals(this.vhID)) continue;
                vhState = state;
            }
            if (vhState != null && vhState.isDeleted()) {
                return;
            }
            throw new RepositoryException("Version history is not found. UUID: " + this.vhID + ". Context item (ancestor to save) " + this.ancestorToSave.getAsString());
        }
        for (String wsName : this.repository.getWorkspaceNames()) {
            Object var10_16;
            SessionImpl wsSession;
            block15: {
                block14: {
                    wsSession = this.repository.getSystemSession(wsName);
                    try {
                        for (PropertyData sref : wsSession.getTransientNodesManager().getReferencesData(this.vhID, false)) {
                            if (sref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) {
                                if (sref.getQPath().isDescendantOf(vhnode.getQPath())) continue;
                                if (this.containingHistory != null) {
                                    if (sref.getQPath().isDescendantOf(this.containingHistory)) continue;
                                }
                                var10_16 = null;
                                wsSession.logout();
                                return;
                            }
                            if (this.currentWorkspaceName.equals(wsName)) continue;
                            break block14;
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        var10_16 = null;
                        wsSession.logout();
                        throw throwable;
                    }
                }
                var10_16 = null;
                wsSession.logout();
                return;
            }
            var10_16 = null;
            wsSession.logout();
        }
        List<NodeData> childs = this.dataManager.getChildNodesData(vhnode);
        Iterator<NodeData> i$ = childs.iterator();
        while (true) {
            String childVhID;
            if (!i$.hasNext()) {
                ItemDataRemoveVisitor visitor = new ItemDataRemoveVisitor(this.dataManager, this.ancestorToSave);
                vhnode.accept(visitor);
                this.transientChangesLog.addAll(visitor.getRemovedStates());
                return;
            }
            NodeData nodeData = i$.next();
            if (!this.ntManager.isNodeType(Constants.NT_VERSIONEDCHILD, vhnode.getPrimaryTypeName(), vhnode.getMixinTypeNames())) continue;
            PropertyData property = (PropertyData)this.dataManager.getItemData(nodeData, new QPathEntry(Constants.JCR_CHILDVERSIONHISTORY, 1));
            if (property == null) {
                throw new RepositoryException("Property " + Constants.JCR_CHILDVERSIONHISTORY.getAsString() + " for node " + nodeData.getQPath().getAsString() + " not found");
            }
            try {
                childVhID = new String(property.getValues().get(0).getAsByteArray());
            }
            catch (IOException e) {
                throw new RepositoryException("Child version history UUID read error " + e, (Throwable)e);
            }
            VersionHistoryRemover historyRemover = new VersionHistoryRemover(childVhID, this.dataManager, this.ntManager, this.repository, this.currentWorkspaceName, this.containingHistory, this.ancestorToSave, this.transientChangesLog, this.accessManager, this.userState);
            historyRemover.remove();
        }
    }
}

