/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;

public class AvatarAttachment {
    private String id;
    private String fileName;
    private String mimeType;
    private String workspace;
    private byte[] imageBytes;
    private long lastModified;

    public String getDataPath(PortalContainer portalContainer) throws Exception {
        Node attachmentData;
        try {
            attachmentData = (Node)this.getSesison(portalContainer).getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return attachmentData.getPath();
    }

    public String getDataPath() throws Exception {
        Node attachmentData;
        try {
            attachmentData = (Node)this.getSesison().getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return attachmentData.getPath();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String ws) {
        this.workspace = ws;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String s) {
        this.fileName = s;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String s) {
        this.mimeType = s;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getSize() {
        int length = this.imageBytes.length;
        int KB_SIZE = 1024;
        int MB_SIZE = 1024 * KB_SIZE;
        if (length >= MB_SIZE) {
            double size = length / MB_SIZE;
            return size + " MB";
        }
        if (length >= KB_SIZE) {
            double size = length / KB_SIZE;
            return size + " KB";
        }
        return length + " Bytes";
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setInputStream(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes = new byte[input.available()];
            input.read(this.imageBytes);
        } else {
            this.imageBytes = null;
        }
    }

    public InputStream getInputStream(Session session) throws Exception {
        Node attachment;
        if (this.imageBytes != null) {
            return new ByteArrayInputStream(this.imageBytes);
        }
        try {
            attachment = (Node)session.getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (PathNotFoundException ex) {
            return null;
        }
        Property property = attachment.getNode("jcr:content").getProperty("jcr:data");
        InputStream inputStream = property.getValue().getStream();
        return inputStream;
    }

    private Session getSesison(PortalContainer portalcontainer) throws Exception {
        RepositoryService repoService = (RepositoryService)portalcontainer.getComponentInstanceOfType(RepositoryService.class);
        return repoService.getDefaultRepository().getSystemSession(this.workspace);
    }

    private Session getSesison() throws Exception {
        RepositoryService repoService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        return repoService.getDefaultRepository().getSystemSession(this.workspace);
    }
}

