/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.util;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.chars.TextVerifier;
import org.exoplatform.services.chars.ValueVerifier;
import org.exoplatform.services.common.ServiceConfig;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.util.URLCreator;
import org.exoplatform.services.token.attribute.Attribute;
import org.exoplatform.services.token.attribute.AttributeParser;
import org.exoplatform.services.token.attribute.AttributeUtil;
import org.exoplatform.services.token.attribute.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceConfig(type=ServiceConfig.ServiceType.SOFT_REFERENCE)
public class HyperLinkUtil
extends AttributeUtil {
    public synchronized List<String> getSiteLink(HTMLNode node) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("a", "href");
        map.put("iframe", "src");
        map.put("frame", "src");
        map.put("meta", "url");
        return this.getAttributes(node, null, map, new SiteLinkVerifier());
    }

    public synchronized List<String> getImageLink(HTMLNode node) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("img", "src");
        return this.getAttributes(node, null, map, null);
    }

    public synchronized String getSingleImageLink(HTMLNode node) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("img", "src");
        return this.getAttribute(node, map, new ImageLinkVerifier());
    }

    public synchronized void createFullNormalLink(HTMLNode node, URL home) {
        this.createFullNormalLink(node, home, new URLCreator());
    }

    public synchronized void createFullNormalLink(HTMLNode node, URL home, URLCreator creator) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("a", "href");
        map.put("iframe", "src");
        map.put("frame", "src");
        map.put("meta", "url");
        map.put("link", "href");
        this.createFullLink(node, map, home, creator, new NormalLinkVerifier());
    }

    public synchronized void createFullImageLink(HTMLNode node, URL home) {
        this.createFullImageLink(node, home, new URLCreator());
    }

    public synchronized void createFullImageLink(HTMLNode node, URL home, URLCreator creator) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("img", "src");
        this.createFullLink(node, map, home, creator, new ImageLinkVerifier());
    }

    public synchronized void createFullLink(HTMLNode node, Map<String, String> map, URL home, URLCreator creator, ValueVerifier verifier) {
        this.createFullSingleLink(node, map, home, creator, verifier);
        List<HTMLNode> children = node.getChildrenNode();
        for (HTMLNode ele : children) {
            this.createFullLink(ele, map, home, creator, verifier);
        }
    }

    private void createFullSingleLink(HTMLNode node, Map<String, String> map, URL home, URLCreator creator, ValueVerifier verifier) {
        Attribute attr = null;
        Set<String> keys = map.keySet();
        for (String key : keys) {
            Attributes attrs;
            int idx;
            if (!node.isNode(key) || (idx = (attrs = AttributeParser.getAttributes(node)).indexOf(map.get(key))) < 0) continue;
            attr = (Attribute)attrs.get(idx);
            String value = attr.getValue();
            if (verifier != null && !verifier.verify(value)) {
                return;
            }
            value = creator.createURL(home, value);
            attr.setValue(value);
            attrs.set(attr);
            return;
        }
    }

    public static class NormalLinkVerifier
    extends TextVerifier
    implements ValueVerifier {
        public boolean verify(String link) {
            link = link.toLowerCase();
            String[] start = new String[]{"mailto", "javascript", "window", "history"};
            String[] end = new String[0];
            String[] exist = new String[]{"javascript", "#"};
            return !this.startOrEndOrExist(link, start, end, exist);
        }
    }

    public static class ImageLinkVerifier
    extends TextVerifier
    implements ValueVerifier {
        public boolean verify(String link) {
            link = link.toLowerCase();
            String[] exist = new String[]{"img", "image"};
            String[] end = new String[]{"jpg", "gif", "jpeg", "bmp", "dib"};
            return this.existIn(link, exist) || this.endIn(link, end);
        }
    }

    private class SiteLinkVerifier
    extends TextVerifier
    implements ValueVerifier {
        private SiteLinkVerifier() {
        }

        public boolean verify(String link) {
            link = link.toLowerCase();
            String[] start = new String[]{"mailto", "javascript", "window", "history"};
            String[] end = new String[]{"css", "js", "jpg", "gif", "jpeg", "bmp", "dat", "exe", "txt", "java", "pdf", "doc", "rm", "ram", "wma", "wmv", "mp3", "swf", "zip", "jar", "rar"};
            String[] exist = new String[]{"javascript", "img(\"", "image", "#"};
            return !this.startOrEndOrExist(link, start, end, exist);
        }
    }
}

