/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.chars;

import java.io.CharConversionException;
import org.exoplatform.services.chars.StringDecoder;
import sun.io.ByteToCharConverter;

class ConverterSD
extends StringDecoder {
    private ByteToCharConverter btc;

    ConverterSD(ByteToCharConverter btc, String rcn) {
        super(rcn);
        this.btc = btc;
    }

    String charsetName() {
        return this.btc.getCharacterEncoding();
    }

    char[] decode(byte[] ba, int off, int len) {
        int en = this.scale(len, this.btc.getMaxCharsPerByte());
        char[] ca = new char[en];
        if (len == 0) {
            return ca;
        }
        this.btc.reset();
        int n = 0;
        try {
            n = this.btc.convert(ba, off, off + len, ca, 0, en);
            n += this.btc.flush(ca, this.btc.nextCharIndex(), en);
        }
        catch (CharConversionException x) {
            n = this.btc.nextCharIndex();
        }
        return this.trim(ca, n);
    }
}

