/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.impl.core.ExtendedNamespaceRegistry;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceRegistryImpl
implements ExtendedNamespaceRegistry,
Startable {
    public static final Map<String, String> DEF_NAMESPACES = new HashMap<String, String>();
    public static final Map<String, String> DEF_PREFIXES = new HashMap<String, String>();
    private static final Set<String> PROTECTED_NAMESPACES = new HashSet<String>();
    protected static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.NamespaceRegistryImpl");
    private boolean started = false;
    private final DataManager dataManager;
    private final RepositoryIndexSearcherHolder indexSearcherHolder;
    private final Map<String, String> namespaces;
    private final Map<String, String> prefixes;
    private NamespaceDataPersister persister;

    public NamespaceRegistryImpl() {
        this.namespaces = new HashMap<String, String>(DEF_NAMESPACES);
        this.prefixes = new HashMap<String, String>(DEF_PREFIXES);
        this.dataManager = null;
        this.indexSearcherHolder = null;
    }

    public NamespaceRegistryImpl(NamespaceDataPersister persister, DataManager dataManager, RepositoryIndexSearcherHolder indexSearcherHolder) {
        this.dataManager = dataManager;
        this.indexSearcherHolder = indexSearcherHolder;
        this.namespaces = new HashMap<String, String>(DEF_NAMESPACES);
        this.prefixes = new HashMap<String, String>(DEF_PREFIXES);
        this.persister = persister;
    }

    @Override
    public String[] getAllNamespacePrefixes() {
        return this.getPrefixes();
    }

    @Override
    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return this.getPrefix(uri);
    }

    @Override
    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException {
        return this.getURI(prefix);
    }

    @Deprecated
    public Set<String> getNodes(String uri) throws RepositoryException {
        this.validate();
        return this.indexSearcherHolder.getNodesByUri(uri);
    }

    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.prefixes.get(uri);
        if (prefix != null) {
            return prefix;
        }
        throw new NamespaceException("Prefix for " + uri + " not found");
    }

    public String[] getPrefixes() {
        return this.namespaces.keySet().toArray(new String[this.namespaces.keySet().size()]);
    }

    public String getURI(String prefix) throws NamespaceException {
        String uri = this.namespaces.get(prefix);
        if (uri == null) {
            throw new NamespaceException("Unknown Prefix " + prefix);
        }
        return uri;
    }

    public String[] getURIs() {
        return this.namespaces.values().toArray(new String[this.namespaces.size()]);
    }

    public boolean isDefaultNamespace(String uri) {
        return DEF_PREFIXES.containsKey(uri);
    }

    public boolean isDefaultPrefix(String prefix) {
        return DEF_NAMESPACES.containsKey(prefix);
    }

    public boolean isPrefixMaped(String prefix) {
        return this.namespaces.containsKey(prefix);
    }

    public boolean isUriRegistered(String uri) {
        return this.prefixes.containsKey(uri);
    }

    public synchronized void registerNamespace(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.validateNamespace(prefix, uri);
        if (this.namespaces.containsKey(prefix)) {
            this.unregisterNamespace(prefix);
        } else if (this.prefixes.containsKey(uri)) {
            this.unregisterNamespace(this.prefixes.get(uri));
        }
        if (this.persister != null) {
            this.persister.addNamespace(prefix, uri);
        }
        String newPrefix = new String(prefix);
        String newUri = new String(uri);
        this.namespaces.put(newPrefix, newUri);
        this.prefixes.put(newUri, newPrefix);
    }

    public void start() {
        if (!this.started) {
            if (this.persister != null) {
                try {
                    if (!this.persister.isStorageFilled()) {
                        this.persister.addNamespaces(DEF_NAMESPACES);
                    } else {
                        this.persister.loadNamespaces(this.namespaces, this.prefixes);
                    }
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
            }
            this.started = true;
        }
    }

    public void stop() {
    }

    @Override
    public void unregisterNamespace(String prefix) throws NamespaceException, RepositoryException {
        Set<String> nodes;
        if (this.namespaces.get(prefix) == null) {
            throw new NamespaceException("Prefix " + prefix + " is not registered");
        }
        if (PROTECTED_NAMESPACES.contains(prefix)) {
            throw new NamespaceException("Prefix " + prefix + " is protected");
        }
        String uri = this.getURI(prefix);
        if (this.indexSearcherHolder != null && (nodes = this.indexSearcherHolder.getNodesByUri(uri)).size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Fail to unregister namespace");
            buffer.append(prefix);
            buffer.append(" because of following nodes:  ");
            for (String uuid : nodes) {
                ItemData item = this.dataManager.getItemData(uuid);
                if (item == null || !item.isNode()) continue;
                buffer.append(item.getQPath().getAsString());
            }
            buffer.append(" contains whese prefix  ");
            throw new NamespaceException(buffer.toString());
        }
        this.prefixes.remove(uri);
        this.namespaces.remove(prefix);
        if (this.persister != null) {
            this.persister.removeNamespace(prefix);
        }
    }

    public void validateNamespace(String prefix, String uri) throws NamespaceException, RepositoryException {
        if (prefix.indexOf(":") > 0) {
            throw new RepositoryException("Namespace prefix should not contain ':' " + prefix);
        }
        if (PROTECTED_NAMESPACES.contains(prefix)) {
            if (uri == null) {
                throw new NamespaceException("Can not remove built-in namespace " + prefix);
            }
            throw new NamespaceException("Can not change built-in namespace " + prefix);
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new NamespaceException("Can not re-assign prefix that start with 'xml'");
        }
        if (uri == null) {
            throw new NamespaceException("Can not register NULL URI!");
        }
    }

    private void validate() throws RepositoryException {
        if (this.dataManager == null) {
            throw new RepositoryException("Datamanager not initialized");
        }
        if (this.indexSearcherHolder == null) {
            throw new RepositoryException("RepositoryIndexSearcherHolder not initialized");
        }
    }

    static {
        DEF_NAMESPACES.put("", "");
        DEF_NAMESPACES.put("jcr", "http://www.jcp.org/jcr/1.0");
        DEF_NAMESPACES.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        DEF_NAMESPACES.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        DEF_NAMESPACES.put("xml", "http://www.w3.org/XML/1998/namespace");
        DEF_NAMESPACES.put("sv", "http://www.jcp.org/jcr/sv/1.0");
        DEF_NAMESPACES.put("exo", "http://www.exoplatform.com/jcr/exo/1.0");
        DEF_NAMESPACES.put("xs", "http://www.w3.org/2001/XMLSchema");
        DEF_NAMESPACES.put("fn", "http://www.w3.org/2005/xpath-functions");
        DEF_NAMESPACES.put("fn_old", "http://www.w3.org/2004/10/xpath-functions");
        DEF_NAMESPACES.put("rep", "internal");
        DEF_PREFIXES.put("", "");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/1.0", "jcr");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/nt/1.0", "nt");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/mix/1.0", "mix");
        DEF_PREFIXES.put("http://www.w3.org/XML/1998/namespace", "xml");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/sv/1.0", "sv");
        DEF_PREFIXES.put("http://www.exoplatform.com/jcr/exo/1.0", "exo");
        DEF_PREFIXES.put("http://www.w3.org/2001/XMLSchema", "xs");
        DEF_PREFIXES.put("http://www.w3.org/2005/xpath-functions", "fn");
        DEF_PREFIXES.put("http://www.w3.org/2004/10/xpath-functions", "fn_old");
        DEF_PREFIXES.put("internal", "rep");
        PROTECTED_NAMESPACES.add("jcr");
        PROTECTED_NAMESPACES.add("nt");
        PROTECTED_NAMESPACES.add("mix");
        PROTECTED_NAMESPACES.add("xml");
        PROTECTED_NAMESPACES.add("sv");
        PROTECTED_NAMESPACES.add("exo");
    }
}

