/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;

public abstract class NullItemData
implements ItemData {
    public static final String NULL_ID = "_null_id";
    private final String id;
    private final String parentId;
    private final QPathEntry name;
    private final QPath path;

    public NullItemData(NodeData parent, QPathEntry name) {
        this.parentId = parent.getIdentifier();
        this.path = QPath.makeChildPath(parent.getQPath(), name);
        this.name = name;
        this.id = NULL_ID;
    }

    public NullItemData(String id) {
        this.parentId = null;
        this.path = null;
        this.name = null;
        this.id = id;
    }

    public NullItemData() {
        this.parentId = null;
        this.path = null;
        this.name = null;
        this.id = NULL_ID;
    }

    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getParentIdentifier() {
        return this.parentId;
    }

    public int getPersistedVersion() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public QPath getQPath() {
        return this.path;
    }

    public QPathEntry getName() {
        return this.name;
    }
}

