/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.jndi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.impl.jndi.BindableRepositoryFactory;
import org.exoplatform.services.security.MembershipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindableRepositoryImpl
implements Serializable,
Referenceable,
ManageableRepository {
    private transient ManageableRepository delegatee = null;

    public BindableRepositoryImpl(ManageableRepository rep) {
        this.delegatee = rep;
    }

    public String[] getDescriptorKeys() {
        return this.delegatee.getDescriptorKeys();
    }

    public String getDescriptor(String key) {
        return this.delegatee.getDescriptor(key);
    }

    public Session login(Credentials credentials) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login(credentials);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login(workspaceName);
    }

    public Session login() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login();
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegatee.login(credentials, workspaceName);
    }

    @Override
    public Session getSystemSession(String workspaceName) throws RepositoryException {
        return this.delegatee.getSystemSession(workspaceName);
    }

    @Override
    public Session getDynamicSession(String workspaceName, Collection<MembershipEntry> membershipEntries) throws RepositoryException {
        return this.delegatee.getDynamicSession(workspaceName, membershipEntries);
    }

    @Override
    public String[] getWorkspaceNames() {
        return this.delegatee.getWorkspaceNames();
    }

    @Override
    public ExtendedNodeTypeManager getNodeTypeManager() {
        return this.delegatee.getNodeTypeManager();
    }

    @Override
    public NamespaceRegistry getNamespaceRegistry() {
        return this.delegatee.getNamespaceRegistry();
    }

    @Override
    public boolean isWorkspaceInitialized(String workspaceName) throws RepositoryException {
        return this.delegatee.isWorkspaceInitialized(workspaceName);
    }

    @Override
    public RepositoryEntry getConfiguration() {
        return this.delegatee.getConfiguration();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(BindableRepositoryImpl.class.getName(), BindableRepositoryFactory.class.getName(), null);
        ref.add(new StringRefAddr("repositoryName", this.delegatee.getConfiguration().getName()));
        return ref;
    }

    @Override
    public void createWorkspace(String wsName) throws RepositoryException {
        this.delegatee.createWorkspace(wsName);
    }

    @Override
    public void importWorkspace(String wsName, InputStream xmlStream) throws RepositoryException, IOException {
        this.delegatee.importWorkspace(wsName, xmlStream);
    }

    @Override
    public void configWorkspace(WorkspaceEntry wsConfig) throws RepositoryConfigurationException, RepositoryException {
        this.delegatee.configWorkspace(wsConfig);
    }

    @Override
    public boolean canRemoveWorkspace(String workspaceName) throws NoSuchWorkspaceException {
        return this.delegatee.canRemoveWorkspace(workspaceName);
    }

    @Override
    public void removeWorkspace(String workspaceName) throws RepositoryException {
        this.delegatee.removeWorkspace(workspaceName);
    }

    @Override
    public void addItemPersistenceListener(String workspaceName, ItemsPersistenceListener listener) {
        this.delegatee.addItemPersistenceListener(workspaceName, listener);
    }

    @Override
    public WorkspaceContainerFacade getWorkspaceContainer(String workspaceName) {
        return this.delegatee.getWorkspaceContainer(workspaceName);
    }

    @Override
    public int getState() {
        return this.delegatee.getState();
    }

    @Override
    public void setState(int state) {
        this.delegatee.setState(state);
    }
}

