/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.poi.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OOXMLLite {
    private static final Field _classes;
    private File _destDest;
    private File _testDir;
    private File _ooxmlJar;

    OOXMLLite(String dest, String test, String ooxmlJar) {
        this._destDest = new File(dest);
        this._testDir = new File(test);
        this._ooxmlJar = new File(ooxmlJar);
    }

    public static void main(String[] args) throws IOException {
        String dest = null;
        String test = null;
        String ooxml = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-dest")) {
                dest = args[++i];
                continue;
            }
            if (args[i].equals("-test")) {
                test = args[++i];
                continue;
            }
            if (!args[i].equals("-ooxml")) continue;
            ooxml = args[++i];
        }
        OOXMLLite builder = new OOXMLLite(dest, test, ooxml);
        builder.build();
    }

    void build() throws IOException {
        ArrayList<String> lst = new ArrayList<String>();
        System.out.println("Collecting unit tests from " + this._testDir);
        OOXMLLite.collectTests(this._testDir, this._testDir, lst, ".+?\\.Test.+?\\.class$");
        TestSuite suite = new TestSuite();
        for (String arg : lst) {
            if (arg.indexOf(36) != -1) continue;
            String string = arg.replace(".class", "");
            try {
                Class<?> test = Class.forName(string);
                suite.addTestSuite(test);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        TestRunner.run((Test)suite);
        System.out.println("Copying classes to " + this._destDest);
        Map<String, Class<?>> classes = OOXMLLite.getLoadedClasses(this._ooxmlJar.getName());
        for (Class<?> clazz : classes.values()) {
            String factoryClass;
            String className = clazz.getName();
            String classRef = className.replace('.', '/') + ".class";
            File destFile = new File(this._destDest, classRef);
            OOXMLLite.copyFile(clazz.getResourceAsStream('/' + classRef), destFile);
            if (!clazz.isInterface() || classes.containsKey(factoryClass = className + "$Factory")) continue;
            try {
                Class<?> fc = Class.forName(factoryClass);
                className = fc.getName();
                classRef = className.replace('.', '/') + ".class";
                destFile = new File(this._destDest, classRef);
                OOXMLLite.copyFile(fc.getResourceAsStream('/' + classRef), destFile);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Copying .xsb resources");
        JarFile jar = new JarFile(this._ooxmlJar);
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry je = enumeration.nextElement();
            if (!je.getName().matches("schemaorg_apache_xmlbeans/system/\\w+/\\w+\\.xsb")) continue;
            File destFile = new File(this._destDest, je.getName());
            OOXMLLite.copyFile(jar.getInputStream(je), destFile);
        }
        jar.close();
    }

    private static void collectTests(File root, File arg, List<String> out, String ptrn) {
        if (arg.isDirectory()) {
            for (File f : arg.listFiles()) {
                OOXMLLite.collectTests(root, f, out, ptrn);
            }
        } else {
            String prefix;
            String path = arg.getAbsolutePath();
            String cls = path.substring((prefix = root.getAbsolutePath()).length() + 1).replace(File.separator, ".");
            if (cls.matches(ptrn)) {
                out.add(cls);
            }
        }
    }

    private static Map<String, Class<?>> getLoadedClasses(String ptrn) {
        ClassLoader appLoader = ClassLoader.getSystemClassLoader();
        try {
            Vector classes = (Vector)_classes.get(appLoader);
            HashMap map = new HashMap();
            for (Class cls : classes) {
                String jar = cls.getProtectionDomain().getCodeSource().getLocation().toString();
                if (jar.indexOf(ptrn) == -1) continue;
                map.put(cls.getName(), cls);
            }
            return map;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(InputStream srcStream, File destFile) throws IOException {
        File destDirectory = destFile.getParentFile();
        destDirectory.mkdirs();
        FileOutputStream destStream = new FileOutputStream(destFile);
        try {
            IOUtils.copy((InputStream)srcStream, (OutputStream)destStream);
        }
        finally {
            ((OutputStream)destStream).close();
        }
    }

    static {
        try {
            _classes = ClassLoader.class.getDeclaredField("classes");
            _classes.setAccessible(true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

