/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.common.util.DateUtil;
import org.apache.shindig.gadgets.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseBuilder {
    private int httpStatusCode = 200;
    private final Multimap<String, String> headers = HttpResponse.newHeaderMultimap();
    private byte[] responseBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
    private final Map<String, String> metadata = Maps.newHashMap();
    private final List<String> NO_CACHE_HEADER = ImmutableList.of((Object)"no-cache");

    public HttpResponseBuilder() {
    }

    public HttpResponseBuilder(HttpResponseBuilder builder) {
        this.httpStatusCode = builder.httpStatusCode;
        this.headers.putAll(builder.headers);
        this.metadata.putAll(builder.metadata);
        this.responseBytes = builder.responseBytes;
    }

    public HttpResponseBuilder(HttpResponse response) {
        this.httpStatusCode = response.getHttpStatusCode();
        this.headers.putAll(response.getHeaders());
        this.metadata.putAll(response.getMetadata());
        this.responseBytes = response.getResponseAsBytes();
    }

    public HttpResponse create() {
        return new HttpResponse(this);
    }

    public HttpResponseBuilder setResponseString(String body) {
        this.responseBytes = CharsetUtil.getUtf8Bytes((String)body);
        return this;
    }

    public HttpResponseBuilder setResponse(byte[] responseBytes) {
        if (responseBytes == null) {
            responseBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        this.responseBytes = new byte[responseBytes.length];
        System.arraycopy(responseBytes, 0, this.responseBytes, 0, responseBytes.length);
        return this;
    }

    public HttpResponseBuilder setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        return this;
    }

    public HttpResponseBuilder addHeader(String name, String value) {
        if (name != null) {
            this.headers.put((Object)name, (Object)value);
        }
        return this;
    }

    public HttpResponseBuilder setHeader(String name, String value) {
        if (name != null) {
            this.headers.replaceValues((Object)name, (Iterable)Lists.newArrayList((Object[])new String[]{value}));
        }
        return this;
    }

    public HttpResponseBuilder addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    public HttpResponseBuilder addAllHeaders(Map<String, ? extends List<String>> headers) {
        for (Map.Entry<String, ? extends List<String>> entry : headers.entrySet()) {
            this.headers.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        return this;
    }

    public Collection<String> removeHeader(String name) {
        return this.headers.removeAll((Object)name);
    }

    public HttpResponseBuilder setCacheTtl(int cacheTtl) {
        this.headers.removeAll((Object)"Pragma");
        this.headers.removeAll((Object)"Expires");
        this.headers.replaceValues((Object)"Cache-Control", (Iterable)ImmutableList.of((Object)("public,max-age=" + cacheTtl)));
        return this;
    }

    public HttpResponseBuilder setExpirationTime(long expirationTime) {
        this.headers.removeAll((Object)"Cache-Control");
        this.headers.removeAll((Object)"Pragma");
        this.headers.put((Object)"Expires", (Object)DateUtil.formatRfc1123Date((long)expirationTime));
        return this;
    }

    public HttpResponseBuilder setStrictNoCache() {
        this.headers.replaceValues((Object)"Cache-Control", this.NO_CACHE_HEADER);
        this.headers.replaceValues((Object)"Pragma", this.NO_CACHE_HEADER);
        this.headers.removeAll((Object)"Expires");
        return this;
    }

    public HttpResponseBuilder setMetadata(String key, String value) {
        this.metadata.put(key, value);
        return this;
    }

    public HttpResponseBuilder setMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
        return this;
    }

    Multimap<String, String> getHeaders() {
        return this.headers;
    }

    Map<String, String> getMetadata() {
        return this.metadata;
    }

    byte[] getResponse() {
        return this.responseBytes;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

