/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.page.UIPageBrowser;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIRepeater;
import org.exoplatform.webui.core.UIVirtualList;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.UIFormPopupWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageSelector.gtmpl"), @ComponentConfig(id="SelectPage", type=UIPageBrowser.class, template="system:/groovy/portal/webui/page/UIPageBrowser.gtmpl", events={@EventConfig(listeners={SelectPageActionListener.class})})})
public class UIPageSelector
extends UIFormInputContainer<String> {
    private Page page_;
    private static Log logger = ExoLogger.getExoLogger(UIPageSelector.class);

    public UIPageSelector() throws Exception {
        super("UIPageSelector", null);
        UIFormPopupWindow uiPopup = (UIFormPopupWindow)this.addChild(UIFormPopupWindow.class, null, "PopupPageSelector");
        uiPopup.setWindowSize(900, 400);
        uiPopup.setRendered(false);
        UIPageBrowser uiPageBrowser = (UIPageBrowser)this.createUIComponent(UIPageBrowser.class, "SelectPage", null);
        uiPopup.setUIComponent((UIComponent)uiPageBrowser);
        UIVirtualList uiVirtualList = (UIVirtualList)uiPageBrowser.getChild(UIVirtualList.class);
        UIPageSelector.configureVirtualList(uiVirtualList);
    }

    private static void configureVirtualList(UIVirtualList vList) {
        try {
            UIRepeater repeater = (UIRepeater)vList.getUIComponent();
            repeater.configure("pageId", UIPageBrowser.BEAN_FIELD, new String[]{"SelectPage"});
        }
        catch (ClassCastException clCastEx) {
            logger.info((Object)"Could not upcast to UIRepeater", (Throwable)clCastEx);
        }
    }

    public void configure(String iname, String bfield) {
        this.setId(iname);
        this.setName(iname);
        this.setBindingField(bfield);
    }

    public UIFormInput<?> setValue(String value) throws Exception {
        Page page;
        WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UserPortalConfigService service = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        this.page_ = page = service.getPage(value, ctx.getRemoteUser());
        super.setValue((Object)value);
        return this;
    }

    public Page getPage() {
        return this.page_;
    }

    public void setPage(Page page) {
        this.page_ = page;
    }

    public Class<String> getTypeValue() {
        return String.class;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIPageBrowser uiPageBrowser = (UIPageBrowser)this.findFirstComponentOfType(UIPageBrowser.class);
        uiPageBrowser.processDecode(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPageActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            UIPageSelector uiPageSelector = (UIPageSelector)uiPageBrowser.getAncestorOfType(UIPageSelector.class);
            UserPortalConfigService service = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            UserACL userACL = (UserACL)uiPageBrowser.getApplicationComponent(UserACL.class);
            if (!userACL.hasPermission(service.getPage(id))) {
                uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.NoPermission", (Object[])new String[]{id}));
            }
            uiPageSelector.setValue(id);
            uiPageBrowser.feedDataWithQuery(null);
            UIForm uiForm = (UIForm)uiPageSelector.getAncestorOfType(UIForm.class);
            if (uiForm != null) {
                ctx.addUIComponentToUpdateByAjax(uiForm.getParent());
            } else {
                ctx.addUIComponentToUpdateByAjax(uiPageSelector.getParent());
            }
            UIFormPopupWindow uiPopup = (UIFormPopupWindow)uiPageSelector.getChild(UIFormPopupWindow.class);
            uiPopup.setShow(false);
        }
    }
}

