/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.IdentityProviderPlugin;
import org.exoplatform.social.core.identity.model.GlobalId;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileLifeCycle;
import org.exoplatform.social.core.profile.ProfileListener;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.IdentityStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityManager {
    private static final Log LOG = ExoLogger.getExoLogger(IdentityManager.class);
    private static final long SEARCH_LIMIT = 500L;
    private final Map<String, IdentityProvider<?>> identityProviders = new HashMap();
    private IdentityStorage identityStorage;
    private RelationshipManager relationshipManager;
    private final ExoCache<String, Identity> identityCacheById;
    private final ExoCache<GlobalId, Identity> identityCache;
    private final ExoCache<String, List<Identity>> identityListCache;
    private final ProfileLifeCycle profileLifeCycle = new ProfileLifeCycle();

    public IdentityManager(IdentityStorage identityStorage, IdentityProvider<?> defaultIdentityProvider, CacheService cacheService) {
        this.identityStorage = identityStorage;
        this.addIdentityProvider(defaultIdentityProvider);
        this.identityCacheById = cacheService.getCacheInstance(this.getClass().getName() + "identityCacheById");
        this.identityCache = cacheService.getCacheInstance(this.getClass().getName() + "identityCache");
        this.identityListCache = cacheService.getCacheInstance(this.getClass().getName() + "identityListCache");
    }

    public void registerIdentityProviders(IdentityProviderPlugin plugin) {
        List<IdentityProvider<?>> pluginProviders = plugin.getProviders();
        if (pluginProviders != null) {
            for (IdentityProvider<?> identityProvider : pluginProviders) {
                this.addIdentityProvider(identityProvider);
            }
        }
    }

    public Identity getIdentity(String id) {
        return this.getIdentity(id, true);
    }

    public Identity getIdentity(String id, boolean loadProfile) {
        Identity cachedIdentity = null;
        if (GlobalId.isValid(id)) {
            GlobalId globalId = new GlobalId(id);
            String providerId = globalId.getDomain();
            String remoteId = globalId.getLocalId();
            cachedIdentity = (Identity)this.identityCache.get((Serializable)globalId);
            if (cachedIdentity == null) {
                String tempId;
                cachedIdentity = this.getOrCreateIdentity(providerId, remoteId, loadProfile);
                if (cachedIdentity != null) {
                    this.identityCache.put((Serializable)globalId, (Object)cachedIdentity);
                    return cachedIdentity;
                }
                if (cachedIdentity == null && (cachedIdentity = this.identityStorage.findIdentityById(tempId = globalId.getLocalId())) != null) {
                    id = tempId;
                }
            }
        } else {
            cachedIdentity = (Identity)this.identityCacheById.get((Serializable)((Object)id));
            if (cachedIdentity == null) {
                cachedIdentity = this.identityStorage.findIdentityById(id);
            }
        }
        if (cachedIdentity != null) {
            if (loadProfile) {
                this.identityStorage.loadProfile(cachedIdentity.getProfile());
            }
            this.identityCacheById.put((Serializable)((Object)id), (Object)cachedIdentity);
        }
        if (cachedIdentity == null) {
            LOG.info((Object)("Can not get identity with id: " + id));
        }
        return cachedIdentity;
    }

    public void deleteIdentity(Identity identity) {
        if (identity.getId() == null) {
            LOG.warn((Object)("identity.getId() must not be null of [" + identity + "]"));
            return;
        }
        this.identityStorage.deleteIdentity(identity);
        this.identityCacheById.remove((Serializable)((Object)identity.getId()));
        this.identityCache.remove((Serializable)identity.getGlobalId());
        this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
    }

    public void addIdentityProvider(IdentityProvider<?> idProvider) {
        if (idProvider != null) {
            LOG.debug((Object)("Registering identity provider for " + idProvider.getName() + ": " + idProvider));
            this.identityProviders.put(idProvider.getName(), idProvider);
        }
    }

    public long getIdentitiesCount(String providerId) {
        return this.identityStorage.getIdentitiesCount(providerId);
    }

    public Identity getOrCreateIdentity(String providerId, String remoteId) {
        return this.getOrCreateIdentity(providerId, remoteId, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Identity getOrCreateIdentity(String providerId, String remoteId, boolean forceLoadProfile) {
        GlobalId globalIdCacheKey = GlobalId.create(providerId, remoteId);
        Identity cachedIdentity = (Identity)this.identityCache.get((Serializable)globalIdCacheKey);
        if (cachedIdentity == null) {
            IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
            Identity identity1 = identityProvider.getIdentityByRemoteId(remoteId);
            Identity result = this.identityStorage.findIdentity(providerId, remoteId);
            if (result == null) {
                if (identity1 == null) return result;
                this.saveIdentity(identity1);
                this.identityStorage.saveProfile(identity1.getProfile());
                result = identity1;
            } else {
                if (identity1 == null) {
                    this.identityStorage.deleteIdentity(result);
                    return null;
                }
                if (forceLoadProfile) {
                    this.identityStorage.loadProfile(result.getProfile());
                }
            }
            cachedIdentity = result;
            if (cachedIdentity.getId() == null) return cachedIdentity;
            this.identityCache.put((Serializable)globalIdCacheKey, (Object)cachedIdentity);
            return cachedIdentity;
        } else {
            if (!forceLoadProfile) return cachedIdentity;
            this.identityStorage.loadProfile(cachedIdentity.getProfile());
        }
        return cachedIdentity;
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter) throws Exception {
        return this.identityStorage.getIdentitiesByProfileFilter(providerId, profileFilter, 0L, 500L);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.identityStorage.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit);
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter) throws Exception {
        return this.getIdentitiesByProfileFilter(null, profileFilter, 0L, 500L);
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.getIdentitiesByProfileFilter(null, profileFilter, offset, limit);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter) throws Exception {
        return this.identityStorage.getIdentitiesFilterByAlphaBet(providerId, profileFilter, 0L, 500L);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.identityStorage.getIdentitiesFilterByAlphaBet(providerId, profileFilter, offset, limit);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(ProfileFilter profileFilter) throws Exception {
        return this.getIdentitiesFilterByAlphaBet(null, profileFilter);
    }

    public Identity getIdentity(String providerId, String remoteId, boolean loadProfile) {
        GlobalId globalIdCacheKey = GlobalId.create(providerId, remoteId);
        Identity cachedIdentity = (Identity)this.identityCache.get((Serializable)globalIdCacheKey);
        if (cachedIdentity == null) {
            IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
            cachedIdentity = identityProvider.getIdentityByRemoteId(remoteId);
            if (cachedIdentity != null) {
                Identity storedIdentity = this.identityStorage.findIdentity(providerId, remoteId);
                if (storedIdentity != null) {
                    cachedIdentity.setId(storedIdentity.getId());
                    if (loadProfile) {
                        this.identityStorage.loadProfile(cachedIdentity.getProfile());
                    }
                } else {
                    this.identityStorage.saveIdentity(cachedIdentity);
                }
            }
            this.identityCache.put((Serializable)globalIdCacheKey, (Object)cachedIdentity);
        }
        return cachedIdentity;
    }

    public boolean identityExisted(String providerId, String remoteId) {
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        return identityProvider.getIdentityByRemoteId(remoteId) != null;
    }

    public void saveIdentity(Identity identity) {
        this.identityStorage.saveIdentity(identity);
        this.getIdentityProvider(identity.getProviderId()).onSaveIdentity(identity);
        if (identity.getId() != null) {
            this.identityCacheById.remove((Serializable)((Object)identity.getId()));
            this.identityCache.remove((Serializable)identity.getGlobalId());
        }
        this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
    }

    public void saveProfile(Profile profile) {
        this.identityStorage.saveProfile(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
        this.removeCacheForProfileChange(profile);
    }

    private void addOrModifyProfileProperties(Profile profile) throws Exception {
        this.identityStorage.addOrModifyProfileProperties(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
        this.removeCacheForProfileChange(profile);
    }

    private Identity getCachedProfile(Identity identity) {
        Identity cachedIdentity;
        if (identity == null) {
            return null;
        }
        String identityId = identity.getId();
        if (identityId != null && (cachedIdentity = (Identity)this.identityCacheById.get((Serializable)((Object)identityId))) != null) {
            return cachedIdentity;
        }
        GlobalId globalId = identity.getGlobalId();
        if (globalId != null && (cachedIdentity = (Identity)this.identityCache.get((Serializable)globalId)) != null) {
            return cachedIdentity;
        }
        String providerId = identity.getProviderId();
        List listIdentity = (List)this.identityListCache.get((Serializable)((Object)providerId));
        if (listIdentity != null) {
            for (Identity identityFromCache : listIdentity) {
                if (!identityFromCache.equals(identity)) continue;
                return identityFromCache;
            }
        }
        return null;
    }

    public void updateAvatar(Profile p) throws Exception {
        this.saveProfile(p);
        this.profileLifeCycle.avatarUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update avatar successfully for user: " + p));
    }

    public void updateBasicInfo(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.basicUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update basic infomation successfully for user: " + p));
    }

    public void updateContactSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.contactUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update contact section successfully for user: " + p));
    }

    public void updateExperienceSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.experienceUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update experience section successfully for user: " + p));
    }

    public void updateHeaderSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.headerUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update header section successfully for user: " + p));
    }

    public List<Identity> getIdentities(String providerId) throws Exception {
        return this.getIdentities(providerId, true);
    }

    public List<Identity> getIdentities(String providerId, boolean loadProfile) {
        IdentityProvider<?> ip = this.getIdentityProvider(providerId);
        List<String> userids = ip.getAllUserId();
        ArrayList<Identity> ids = new ArrayList<Identity>();
        for (String userId : userids) {
            ids.add(this.getOrCreateIdentity(providerId, userId, loadProfile));
        }
        return ids;
    }

    public List<Identity> getConnections(Identity ownerIdentity) throws Exception {
        this.relationshipManager = this.getRelationshipManager();
        return this.relationshipManager.findRelationships(ownerIdentity, Relationship.Type.CONFIRM);
    }

    public IdentityStorage getStorage() {
        return this.identityStorage;
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    private IdentityProvider<?> getIdentityProvider(String providerId) {
        IdentityProvider<?> provider = this.identityProviders.get(providerId);
        if (provider == null) {
            throw new RuntimeException("No suitable identity provider exists for " + providerId);
        }
        return provider;
    }

    public void registerProfileListener(ProfileListener listener) {
        this.profileLifeCycle.addListener(listener);
    }

    public void unregisterProfileListener(ProfileListener listener) {
        this.profileLifeCycle.removeListener(listener);
    }

    public void addProfileListener(ProfileListenerPlugin plugin) {
        this.registerProfileListener(plugin);
    }

    public IdentityStorage getIdentityStorage() {
        return this.identityStorage;
    }

    private void removeCacheForProfileChange(Profile profile) {
        Identity identity = profile.getIdentity();
        this.identityCacheById.remove((Serializable)((Object)identity.getId()));
        this.identityCache.remove((Serializable)profile.getIdentity().getGlobalId());
        this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = (RelationshipManager)PortalContainer.getInstance().getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }
}

