/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.profile.UIHeaderSection;
import org.exoplatform.social.webui.profile.UIProfile;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.social.webui.profile.UITitleBar;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIBasicInfoSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIBasicInfoSection
extends UIProfileSection {
    public static final String REGEX_EXPRESSION = "^\\p{L}[\\p{L}\\d._,\\s]+\\p{L}$";
    public static final String INVALID_CHAR_MESSAGE = "UIBasicInfoSection.msg.Invalid-char";

    public UIBasicInfoSection() throws Exception {
        String username = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        User useraccount = service.getUserHandler().findUserByName(username);
        this.addChild(UITitleBar.class, null, null);
        UIFormStringInput userName = new UIFormStringInput("username", "username", username);
        userName.setEditable(false);
        this.addUIFormInput((UIFormInput)userName);
        this.addUIFormInput((UIFormInput)new UIFormStringInput("firstName", "firstName", useraccount.getFirstName()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(ExpressionValidator.class, new Object[]{REGEX_EXPRESSION, INVALID_CHAR_MESSAGE}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("lastName", "lastName", useraccount.getLastName()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(ExpressionValidator.class, new Object[]{REGEX_EXPRESSION, INVALID_CHAR_MESSAGE}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("email", "email", useraccount.getEmail()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    public List<UIComponent> getChilds() {
        return this.getChildren();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        private static final String MSG_KEY_UI_ACCOUNT_INPUT_SET_EMAIL_EXIST = "UIAccountInputSet.msg.email-exist";
        private static final String PORTLET_NAME_USER_PROFILE_TOOLBAR_PORTLET = "UserProfileToolBarPortlet";

        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIBasicInfoSection uiForm = (UIBasicInfoSection)((Object)event.getSource());
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            String userName = (String)uiForm.getUIStringInput("username").getValue();
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            User user = service.getUserHandler().findUserByName(userName);
            String oldEmail = user.getEmail();
            String newEmail = (String)uiForm.getUIStringInput("email").getValue();
            Query query = new Query();
            query.setEmail(newEmail);
            if (service.getUserHandler().findUsers(query).getAll().size() > 0 && !oldEmail.equals(newEmail)) {
                user.setEmail(oldEmail);
                Object[] args = new Object[]{userName};
                uiApp.addMessage(new ApplicationMessage(MSG_KEY_UI_ACCOUNT_INPUT_SET_EMAIL_EXIST, args));
                return;
            }
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            Profile p = uiForm.getProfile(true);
            Profile updateProfile = new Profile(p.getIdentity());
            updateProfile.setId(p.getId());
            updateProfile.setProperty("firstName", uiForm.getUIStringInput("firstName").getValue());
            updateProfile.setProperty("lastName", uiForm.getUIStringInput("lastName").getValue());
            updateProfile.setProperty("email", (Object)newEmail);
            IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            im.updateBasicInfo(updateProfile);
            user.setFirstName((String)updateProfile.getProperty("firstName"));
            user.setLastName((String)updateProfile.getProperty("lastName"));
            user.setEmail((String)updateProfile.getProperty("email"));
            service.getUserHandler().saveUser(user, true);
            ConversationState.getCurrent().setAttribute("UserProfile", (Object)user);
            UIProfile uiProfile = (UIProfile)uiForm.getParent();
            context.addUIComponentToUpdateByAjax(uiProfile.getChild(UIHeaderSection.class));
            context.addUIComponentToUpdateByAjax(uiProfile.getChild(UIBasicInfoSection.class));
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChild(UIWorkingWorkspace.class);
            uiWorkingWS.updatePortletsByName(PORTLET_NAME_USER_PROFILE_TOOLBAR_PORTLET);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends UIProfileSection.EditActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIBasicInfoSection uiForm = (UIBasicInfoSection)sect;
            String username = Util.getPortalRequestContext().getRemoteUser();
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            User user = service.getUserHandler().findUserByName(username);
            uiForm.getUIStringInput("firstName").setValue((Object)user.getFirstName());
            uiForm.getUIStringInput("lastName").setValue((Object)user.getLastName());
            uiForm.getUIStringInput("email").setValue((Object)user.getEmail());
            WebuiRequestContext requestContext = event.getRequestContext();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiForm);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)sect);
        }
    }
}

