/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import java.util.ArrayList;
import javax.jcr.PathNotFoundException;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QPath
implements Comparable<QPath> {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.QPath");
    public static final String PREFIX_DELIMITER = ":";
    private final QPathEntry[] names;
    private final int hashCode;
    private String stringName;

    public QPath(QPathEntry[] names) {
        this.names = names;
        int prime = 31;
        int hash = names.length > 0 ? 1 : super.hashCode();
        for (QPathEntry entry : names) {
            hash = 31 * hash + entry.hashCode();
            hash = 31 * hash + entry.getIndex();
        }
        this.hashCode = hash;
    }

    public boolean isAbsolute() {
        return this.names[0].getIndex() == 1 && this.names[0].getName().length() == 0 && this.names[0].getNamespace().length() == 0;
    }

    public QPath makeParentPath() {
        return this.makeAncestorPath(1);
    }

    public QPath makeAncestorPath(int relativeDegree) {
        int entryCount = this.getLength() - relativeDegree;
        QPathEntry[] ancestorEntries = new QPathEntry[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            QPathEntry entry = this.names[i];
            ancestorEntries[i] = new QPathEntry(entry.getNamespace(), entry.getName(), entry.getIndex());
        }
        return new QPath(ancestorEntries);
    }

    public QPathEntry[] getRelPath(int relativeDegree) throws IllegalPathException {
        int len = this.getLength() - relativeDegree;
        if (len < 0) {
            throw new IllegalPathException("Relative degree " + relativeDegree + " is more than depth for " + this.getAsString());
        }
        QPathEntry[] relPath = new QPathEntry[relativeDegree];
        System.arraycopy(this.names, len, relPath, 0, relPath.length);
        return relPath;
    }

    public QPathEntry[] getEntries() {
        return this.names;
    }

    public int getDepth() {
        return this.names.length - 1;
    }

    public boolean isDescendantOf(QPath ancestorPath) {
        QPathEntry[] ancestorNames = ancestorPath.names;
        if (this.names.length - ancestorNames.length <= 0) {
            return false;
        }
        for (int i = 0; i < ancestorNames.length; ++i) {
            if (this.names[i].equals(ancestorNames[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isDescendantOf(QPath anotherPath, boolean childOnly) {
        QPathEntry[] anotherNames = anotherPath.names;
        int depthDiff = this.names.length - anotherNames.length;
        if (depthDiff <= 0 || childOnly && depthDiff != 1) {
            return false;
        }
        for (int i = 0; i < anotherNames.length; ++i) {
            if (((InternalQName)anotherNames[i]).equals(this.names[i])) continue;
            return false;
        }
        return true;
    }

    public static QPath getCommonAncestorPath(QPath firstPath, QPath secondPath) throws PathNotFoundException {
        if (!firstPath.getEntries()[0].equals(secondPath.getEntries()[0])) {
            throw new PathNotFoundException("For the given ways there is no common ancestor.");
        }
        ArrayList<QPathEntry> caEntries = new ArrayList<QPathEntry>();
        for (int i = 0; i < firstPath.getEntries().length && firstPath.getEntries()[i].equals(secondPath.getEntries()[i]); ++i) {
            caEntries.add(firstPath.getEntries()[i]);
        }
        return new QPath(caEntries.toArray(new QPathEntry[caEntries.size()]));
    }

    public InternalQName getName() {
        return this.names[this.getLength() - 1];
    }

    public int getIndex() {
        return this.names[this.getLength() - 1].getIndex();
    }

    protected int getLength() {
        return this.names.length;
    }

    public String getAsString() {
        if (this.stringName == null) {
            String str = "";
            for (int i = 0; i < this.getLength(); ++i) {
                str = str + this.names[i].getAsString(true);
            }
            this.stringName = str;
        }
        return this.stringName;
    }

    public String toString() {
        return super.toString() + " (" + this.getAsString() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QPath)) {
            return false;
        }
        return this.hashCode == o.hashCode();
    }

    @Override
    public int compareTo(QPath compare) {
        if (compare.equals(this)) {
            return 0;
        }
        QPathEntry[] e1 = this.names;
        QPathEntry[] e2 = compare.getEntries();
        int len1 = e1.length;
        int len2 = e2.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            QPathEntry c1 = e1[k];
            QPathEntry c2 = e2[k];
            if (c1.isSame(c2)) continue;
            return c1.compareTo(c2);
        }
        return len1 - len2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static QPath parse(String qPath) throws IllegalPathException {
        if (qPath == null) {
            throw new IllegalPathException("Bad internal path '" + qPath + "'");
        }
        if (qPath.length() < 2 || !qPath.startsWith("[]")) {
            throw new IllegalPathException("Bad internal path '" + qPath + "'");
        }
        int uriStart = 0;
        ArrayList<QPathEntry> entries = new ArrayList<QPathEntry>();
        while (uriStart >= 0) {
            uriStart = qPath.indexOf("[", uriStart);
            int uriFinish = qPath.indexOf("]", uriStart);
            String uri = qPath.substring(uriStart + 1, uriFinish);
            int tmp = qPath.indexOf("[", uriFinish);
            if (tmp == -1) {
                tmp = qPath.length();
                uriStart = -1;
            } else {
                uriStart = tmp;
            }
            String localName = qPath.substring(uriFinish + 1, tmp);
            int index = 0;
            int ind = localName.indexOf(PREFIX_DELIMITER);
            if (ind != -1) {
                index = Integer.parseInt(localName.substring(ind + 1));
                localName = localName.substring(0, ind);
            } else if (uriStart > -1) {
                throw new IllegalPathException("Bad internal path '" + qPath + "' each intermediate name should have index");
            }
            entries.add(new QPathEntry(uri, localName, index));
        }
        return new QPath(entries.toArray(new QPathEntry[entries.size()]));
    }

    @Deprecated
    public static QPath makeChildPath(QPath parent, String name) throws IllegalPathException {
        QPathEntry[] parentEntries = parent.getEntries();
        QPathEntry[] names = new QPathEntry[parentEntries.length + 1];
        int index = 0;
        for (QPathEntry pname : parentEntries) {
            names[index++] = pname;
        }
        names[index] = QPath.parseEntry(name);
        QPath path = new QPath(names);
        return path;
    }

    public static QPath makeChildPath(QPath parent, InternalQName name) {
        return QPath.makeChildPath(parent, name, 1);
    }

    public static QPath makeChildPath(QPath parent, QName name, int itemIndex) {
        QPathEntry[] parentEntries = parent.getEntries();
        QPathEntry[] names = new QPathEntry[parentEntries.length + 1];
        int index = 0;
        for (QPathEntry pname : parentEntries) {
            names[index++] = pname;
        }
        names[index] = new QPathEntry(name.getNamespace(), name.getName(), itemIndex);
        QPath path = new QPath(names);
        return path;
    }

    public static QPath makeChildPath(QPath parent, QPathEntry[] relEntries) {
        QPathEntry[] parentEntries = parent.getEntries();
        QPathEntry[] names = new QPathEntry[parentEntries.length + relEntries.length];
        int index = 0;
        for (QPathEntry name : parentEntries) {
            names[index++] = name;
        }
        for (QPathEntry name : relEntries) {
            names[index++] = name;
        }
        QPath path = new QPath(names);
        return path;
    }

    public static QPath makeChildPath(QPath parent, QPathEntry relEntry) {
        QPathEntry[] parentEntries = parent.getEntries();
        QPathEntry[] names = new QPathEntry[parentEntries.length + 1];
        int index = 0;
        for (QPathEntry name : parentEntries) {
            names[index++] = name;
        }
        names[index] = relEntry;
        QPath path = new QPath(names);
        return path;
    }

    private static QPathEntry parseEntry(String entry) throws IllegalPathException {
        if (!entry.startsWith("[")) {
            throw new IllegalPathException("Invalid QPath Entry '" + entry + "' Should start of '['");
        }
        boolean uriStart = false;
        int uriFinish = entry.indexOf("]", 0);
        if (uriFinish == -1) {
            throw new IllegalPathException("Invalid QPath Entry '" + entry + "' No closed ']'");
        }
        String uri = entry.substring(1, uriFinish);
        String localName = entry.substring(uriFinish + 1, entry.length());
        int ind = localName.indexOf(PREFIX_DELIMITER);
        if (ind > 1) {
            return new QPathEntry(uri, localName.substring(0, ind), Integer.parseInt(localName.substring(ind + 1)));
        }
        return new QPathEntry(uri, localName, 1);
    }
}

