/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.chromattic.metamodel.bean.MultiValuedPropertyInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleType;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.mapping.jcr.JCRPropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDefinition {
    final String name;
    final boolean multiple;
    final int type;
    final List<String> defaultValues;

    PropertyDefinition(String name, boolean multiple, int type) {
        this.name = name;
        this.multiple = multiple;
        this.type = type;
        this.defaultValues = null;
    }

    <V> PropertyDefinition(JCRPropertyMapping<V> mapping, PropertyInfo<SimpleValueInfo<V>> propertyInfo) {
        int propertyType;
        SimpleValueInfo<V> simpleValueInfo;
        SimpleType<V> stk;
        List<String> defaultValues = null;
        List<V> defaultValue = mapping.getDefaultValue();
        if (defaultValue != null) {
            defaultValues = new ArrayList(defaultValue.size());
            for (V v : defaultValue) {
                String s = propertyInfo.getValue().getSimpleType().toString(v);
                defaultValues.add(s);
            }
            defaultValues = Collections.unmodifiableList(defaultValues);
        }
        if ((stk = (simpleValueInfo = propertyInfo.getValue()).getSimpleType()) == SimpleType.STRING) {
            propertyType = 1;
        } else if (stk == SimpleType.LONG || stk == SimpleType.PRIMITIVE_LONG) {
            propertyType = 3;
        } else if (stk == SimpleType.PATH) {
            propertyType = 8;
        } else if (stk == SimpleType.DATE) {
            propertyType = 5;
        } else if (stk == SimpleType.BOOLEAN || stk == SimpleType.PRIMITIVE_BOOLEAN) {
            propertyType = 6;
        } else if (stk == SimpleType.INTEGER || stk == SimpleType.PRIMITIVE_INTEGER) {
            propertyType = 3;
        } else if (stk == SimpleType.FLOAT || stk == SimpleType.PRIMITIVE_FLOAT) {
            propertyType = 4;
        } else if (stk == SimpleType.DOUBLE || stk == SimpleType.PRIMITIVE_DOUBLE) {
            propertyType = 4;
        } else if (stk == SimpleType.STREAM) {
            propertyType = 2;
        } else if (stk instanceof SimpleType.Enumerated) {
            propertyType = 1;
        } else {
            throw new AssertionError();
        }
        this.multiple = propertyInfo instanceof MultiValuedPropertyInfo;
        this.name = mapping.getName();
        this.type = propertyType;
        this.defaultValues = defaultValues;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public int getType() {
        return this.type;
    }
}

